/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.StructureData;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.dt.DataIterator;
import ucar.nc2.dt.EarthLocation;
import ucar.nc2.dt.PointObsDatatype;
import ucar.unidata.geoloc.LatLonRect;

public interface TrajectoryObsDatatype {
    public String getId();

    public String getDescription();

    public int getNumberPoints();

    public List getDataVariables();

    public VariableSimpleIF getDataVariable(String var1);

    public PointObsDatatype getPointObsData(int var1) throws IOException;

    public Date getStartDate();

    public Date getEndDate();

    public LatLonRect getBoundingBox();

    public Date getTime(int var1) throws IOException;

    public EarthLocation getLocation(int var1) throws IOException;

    public double getTimeValue(int var1) throws IOException;

    public String getTimeUnitsIdentifier();

    public double getLatitude(int var1) throws IOException;

    public double getLongitude(int var1) throws IOException;

    public double getElevation(int var1) throws IOException;

    public StructureData getData(int var1) throws IOException, InvalidRangeException;

    public Array getData(int var1, String var2) throws IOException;

    public DataIterator getDataIterator(int var1) throws IOException;

    public Range getFullRange();

    public Range getPointRange(int var1) throws InvalidRangeException;

    public Range getRange(int var1, int var2, int var3) throws InvalidRangeException;

    public Array getTime(Range var1) throws IOException, InvalidRangeException;

    public Array getLatitude(Range var1) throws IOException, InvalidRangeException;

    public Array getLongitude(Range var1) throws IOException, InvalidRangeException;

    public Array getElevation(Range var1) throws IOException, InvalidRangeException;

    public Array getData(Range var1, String var2) throws IOException, InvalidRangeException;
}

