/*
 * Decompiled with CFR 0.152.
 */
package net.java.swingfx.jdraggable;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import net.java.swingfx.jdraggable.DraggableManager;

public class DraggableListener
extends MouseInputAdapter {
    private Point componentTopLeft;
    private Point componentTopRight;
    private Point componentBottomLeft;
    private Point componentBottomRight;
    private Point containerTopLeft;
    private Point containerTopRight;
    private Point containerBottomLeft;
    private Point containerBottomRight;
    private DraggableManager dragManager;
    private Component draggableComponent;
    private Container draggableContainer;
    private int offsetX;
    private int offsetY;

    public DraggableListener(DraggableManager dragManager) {
        this.dragManager = dragManager;
        this.draggableContainer = dragManager.getDraggableContainer();
    }

    public void mouseDragged(MouseEvent e) {
        if (this.dragManager.dragging()) {
            if (this.dragManager.shouldNullifyLayout() && this.draggableContainer.getLayout() != null) {
                this.draggableContainer.setLayout(null);
            }
            int x = e.getX();
            int y = e.getY();
            Point pt = SwingUtilities.convertPoint(this.draggableComponent, x, y, this.draggableContainer);
            this.draggableComponent.setLocation(pt.x - this.offsetX, pt.y - this.offsetY);
            this.stayInContainer();
        }
    }

    public void mousePressed(MouseEvent e) {
        this.draggableComponent = e.getComponent();
        if (this.dragManager.startDrag(this.draggableComponent)) {
            this.offsetX = e.getX();
            this.offsetY = e.getY();
        }
    }

    public void mouseReleased(MouseEvent e) {
        this.dragManager.stopDrag();
        this.draggableComponent = null;
    }

    private boolean isInContainer() {
        Rectangle r = new Rectangle(this.draggableContainer.getWidth(), this.draggableContainer.getHeight());
        int wC = (int)r.getWidth();
        int hC = (int)r.getHeight();
        this.containerTopLeft = r.getLocation();
        this.containerTopRight = new Point((int)this.containerTopLeft.getX() + wC, (int)this.containerTopLeft.getY());
        this.containerBottomLeft = new Point((int)this.containerTopLeft.getX(), (int)this.containerTopLeft.getY() + hC);
        this.containerBottomRight = new Point((int)this.containerTopLeft.getX() + wC, (int)this.containerTopLeft.getY() + hC);
        int w = this.draggableComponent.getWidth();
        int h = this.draggableComponent.getHeight();
        this.componentTopLeft = this.draggableComponent.getLocation();
        this.componentTopRight = new Point((int)this.componentTopLeft.getX() + w, (int)this.componentTopLeft.getY());
        this.componentBottomLeft = new Point((int)this.componentTopLeft.getX(), (int)this.componentTopLeft.getY() + h);
        this.componentBottomRight = new Point((int)this.componentTopLeft.getX() + w, (int)this.componentTopLeft.getY() + h);
        if (!r.contains(this.componentTopLeft)) {
            return false;
        }
        if (!r.contains(this.componentTopRight)) {
            return false;
        }
        if (!r.contains(this.componentBottomLeft)) {
            return false;
        }
        return r.contains(this.componentBottomRight);
    }

    private void stayInContainer() {
        double yC;
        double y;
        double xC;
        double x;
        if (!this.isInContainer() && (x = this.componentTopRight.getX()) > (xC = this.containerTopRight.getX())) {
            this.draggableComponent.setLocation((int)(this.componentTopLeft.getX() + xC - x), (int)this.componentTopLeft.getY());
        }
        if (!this.isInContainer() && (x = this.componentTopLeft.getX()) < (xC = this.containerTopLeft.getX())) {
            this.draggableComponent.setLocation((int)(this.componentTopLeft.getX() + xC - x), (int)this.componentTopLeft.getY());
        }
        if (!this.isInContainer() && (y = this.componentTopLeft.getY()) < (yC = this.containerTopLeft.getY())) {
            this.draggableComponent.setLocation((int)this.componentTopLeft.getX(), (int)(this.componentTopLeft.getY() + yC - y));
        }
        if (!this.isInContainer() && (y = this.componentBottomLeft.getY()) > (yC = this.containerBottomLeft.getY())) {
            this.draggableComponent.setLocation((int)this.componentTopLeft.getX(), (int)(this.componentTopLeft.getY() + yC - y));
        }
    }
}

