/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.data;

import java.util.StringTokenizer;

public class PersonName {
    public static final int FAMILY = 0;
    public static final int GIVEN = 1;
    public static final int MIDDLE = 2;
    public static final int PREFIX = 3;
    public static final int SUFFIX = 4;
    public static final int SINGLE_BYTE = 0;
    public static final int IDEOGRAPHIC = 1;
    public static final int PHONETIC = 2;
    private final String[][] components = new String[][]{new String[5], new String[5], new String[5]};

    public PersonName() {
    }

    public PersonName(String s) {
        if (s == null) {
            return;
        }
        s = s.trim();
        int group = 0;
        int field = 0;
        try {
            StringTokenizer stk = new StringTokenizer(s, "^=", true);
            while (stk.hasMoreTokens()) {
                String tk = stk.nextToken();
                if (tk.equals("^")) {
                    ++field;
                    continue;
                }
                if (tk.equals("=")) {
                    ++group;
                    field = 0;
                    continue;
                }
                this.set(group, field, tk);
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException(s);
        }
    }

    public static PersonName[] toPersonNames(String[] ss) {
        if (ss == null) {
            return null;
        }
        PersonName[] pns = new PersonName[ss.length];
        for (int i = 0; i < pns.length; ++i) {
            pns[i] = new PersonName(ss[i]);
        }
        return pns;
    }

    public final String get(int field) {
        return this.get(0, field);
    }

    public final String get(int group, int field) {
        return this.components[group][field];
    }

    public final void set(int field, String s) {
        this.set(0, field, s);
    }

    public final void set(int group, int field, String s) {
        if (s != null && (s = s.trim()).length() == 0) {
            s = null;
        }
        this.components[group][field] = s;
    }

    public String toString() {
        int[] groupLen = new int[]{0, 0, 0};
        int[] compDelim = new int[]{0, 0, 0};
        int groupDelim = 0;
        for (int g = 0; g < 3; ++g) {
            for (int c = 0; c < 5; ++c) {
                if (this.components[g][c] == null) continue;
                int n = g;
                groupLen[n] = groupLen[n] + this.components[g][c].length();
                compDelim[g] = c;
                groupDelim = g;
            }
        }
        int len = groupLen[0] + groupLen[1] + groupLen[2] + compDelim[0] + compDelim[1] + compDelim[2] + groupDelim;
        if (len == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer(len);
        for (int g = 0; g <= groupDelim; ++g) {
            if (g != 0) {
                sb.append('=');
            }
            for (int c = 0; c <= compDelim[g]; ++c) {
                if (c != 0) {
                    sb.append('^');
                }
                if (this.components[g][c] == null) continue;
                sb.append(this.components[g][c]);
            }
        }
        return sb.toString();
    }

    public String componentGroupString(int group, boolean trim) {
        int len = 0;
        int delim = 0;
        for (int c = 0; c < 5; ++c) {
            if (this.components[group][c] == null) continue;
            len += this.components[group][c].length();
            delim = c;
        }
        if (len == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer(len + (trim ? delim : 4));
        for (int c = 0; c <= delim; ++c) {
            if (c != 0) {
                sb.append('^');
            }
            if (this.components[group][c] == null) continue;
            sb.append(this.components[group][c]);
        }
        if (!trim) {
            while (delim < 4) {
                sb.append('^');
                ++delim;
            }
        }
        return sb.toString();
    }
}

