/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.application.avmisdnmonitor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.util.Properties;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import uk.co.mmscomputing.concurrent.Semaphore;
import uk.co.mmscomputing.concurrent.TimeUnit;
import uk.co.mmscomputing.device.capi.CapiConfMsg;
import uk.co.mmscomputing.device.capi.CapiProfile;
import uk.co.mmscomputing.device.capi.MsgIn;
import uk.co.mmscomputing.device.capi.facility.SupServiceConf;
import uk.co.mmscomputing.device.capi.facility.SupServiceReq;
import uk.co.mmscomputing.device.capi.jcapi;
import uk.co.mmscomputing.device.capi.man.avm.AVMGetBChannelInfoConf;
import uk.co.mmscomputing.device.capi.man.avm.AVMGetBChannelInfoReq;
import uk.co.mmscomputing.device.capi.man.avm.AVMProfile;
import uk.co.mmscomputing.util.UtilMainApp;

public class MainApp
extends UtilMainApp
implements Runnable {
    private int appid = -1;
    private int cntlid = 1;
    private int noc = 0;
    private boolean running = false;
    private JPanel panel;
    private JPanel profilePanel;
    private JLabel registeredApplications;
    private JLabel isdnLine;
    private JLabel dChannel;
    private JLabel[] bChannels;
    private int ra = -1;
    private boolean il = false;
    private boolean dc = false;
    private boolean[] bcs = null;

    public MainApp() {
    }

    public MainApp(String string, String[] stringArray) {
        super(string, stringArray);
    }

    protected JPanel getCenterPanel(Properties properties) throws Exception {
        this.registeredApplications = new JLabel();
        this.isdnLine = new JLabel();
        this.dChannel = new JLabel();
        JPanel jPanel = new JPanel(new GridLayout(0, 2));
        jPanel.add(new JLabel("Registered Applications:"));
        jPanel.add(this.registeredApplications);
        jPanel.add(new JLabel("ISDN-Line :"));
        jPanel.add(this.isdnLine);
        jPanel.add(new JLabel("D-Channel :"));
        jPanel.add(this.dChannel);
        this.panel = jPanel;
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel2.add((Component)jPanel, "North");
        jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JScrollPane(jPanel2), "Center");
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addTab("Monitor", jPanel);
        this.profilePanel = new JPanel(new BorderLayout());
        jTabbedPane.addTab("Profile", this.profilePanel);
        jPanel = new JPanel(new BorderLayout());
        jPanel.add(jTabbedPane);
        return jPanel;
    }

    protected void setFrameSize(JFrame jFrame, Rectangle rectangle) {
        jFrame.setSize(450, 250);
    }

    private void createProfileAndBChannelIndicators(int n, int n2) throws Exception {
        Object object;
        AVMProfile aVMProfile = new AVMProfile(jcapi.getProfile(n2));
        DefaultMutableTreeNode defaultMutableTreeNode = ((CapiProfile)aVMProfile).toTree();
        if (aVMProfile.isSupportingSupplementaryServices()) {
            jcapi.putMessage(n, new SupServiceReq.GetSupportedServicesReq(n, n2).getBytes());
            jcapi.waitForMessage(n);
            object = MsgIn.create(jcapi.getMessage(n, null));
            if (object instanceof SupServiceConf.GetSupportedServicesConf && ((CapiConfMsg)object).getInfo() == 0) {
                defaultMutableTreeNode.add(((SupServiceConf.GetSupportedServicesConf)object).toTree());
            }
        }
        object = new JTree(defaultMutableTreeNode);
        JScrollPane jScrollPane = new JScrollPane((Component)object);
        this.profilePanel.add(jScrollPane);
        this.noc = aVMProfile.getNoOfBChannels();
        this.bChannels = new JLabel[this.noc];
        this.bcs = new boolean[this.noc];
        for (int i = 0; i < this.noc; ++i) {
            this.panel.add(new JLabel("B-Channel [" + i + "]:"));
            this.bChannels[i] = new JLabel();
            this.panel.add(this.bChannels[i]);
        }
    }

    public void start() {
        super.start();
        new Thread(this).start();
    }

    public void stop() {
        this.running = false;
        super.stop();
    }

    protected void signalRegisteredApplicationChange(int n) {
        System.out.println("Applications " + n);
    }

    protected void signalISDNLineStateChange(boolean bl) {
        System.out.println("ISDN-Line " + (bl ? "UP" : "down"));
    }

    protected void signalDChannelStateChange(boolean bl) {
        System.out.println("D-Channel " + (bl ? "UP" : "down"));
    }

    protected void signalBChannelStateChange(int n, boolean bl) {
        System.out.println("B-Channel [" + n + "] " + (bl ? "UP" : "down"));
    }

    protected void handleMessage(MsgIn msgIn) {
        if (msgIn instanceof AVMGetBChannelInfoConf) {
            boolean bl;
            boolean bl2;
            AVMGetBChannelInfoConf aVMGetBChannelInfoConf = (AVMGetBChannelInfoConf)msgIn;
            int n = aVMGetBChannelInfoConf.getRegisteredApplicationCount();
            this.registeredApplications.setText("" + n);
            if (this.ra != n) {
                this.ra = n;
                this.signalRegisteredApplicationChange(this.ra);
            }
            this.isdnLine.setText((bl2 = aVMGetBChannelInfoConf.isISDNLineActive()) ? "ACTIVE" : "inactive");
            if (this.il != bl2) {
                this.il = bl2;
                this.signalISDNLineStateChange(this.il);
            }
            this.dChannel.setText((bl = aVMGetBChannelInfoConf.isDChannelActive()) ? "ACTIVE" : "inactive");
            if (this.dc != bl) {
                this.dc = bl;
                this.signalDChannelStateChange(this.dc);
            }
            for (int i = 0; i < this.noc; ++i) {
                boolean bl3 = aVMGetBChannelInfoConf.isBChannelActive(i);
                this.bChannels[i].setText(bl3 ? "ACTIVE" : "inactive");
                if (this.bcs[i] == bl3) continue;
                this.bcs[i] = bl3;
                this.signalBChannelStateChange(i, bl3);
            }
        } else {
            System.out.println(msgIn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block9: {
            try {
                jcapi.checkInstalled();
                String string = jcapi.getManufacturer(this.cntlid).toLowerCase();
                if (string.indexOf("avm") >= 0) {
                    this.appid = jcapi.register(this.cntlid, 2, 128);
                    try {
                        this.running = true;
                        this.createProfileAndBChannelIndicators(this.appid, this.cntlid);
                        Semaphore semaphore = new Semaphore(0, true);
                        byte[] byArray = null;
                        while (this.running) {
                            AVMGetBChannelInfoReq aVMGetBChannelInfoReq = new AVMGetBChannelInfoReq(this.appid, this.cntlid);
                            jcapi.putMessage(this.appid, aVMGetBChannelInfoReq.getBytes());
                            jcapi.waitForMessage(this.appid);
                            if (!this.running) {
                                break block9;
                            }
                            byArray = jcapi.getMessage(this.appid, byArray);
                            MsgIn msgIn = MsgIn.create(byArray);
                            this.handleMessage(msgIn);
                            semaphore.tryAcquire(500L, TimeUnit.MILLISECONDS);
                        }
                        break block9;
                    }
                    finally {
                        jcapi.release(this.appid);
                    }
                }
                System.out.println("9\bSorry, this program works only with AVM ISDN cards!");
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception exception) {
                System.out.println("9\b" + this.getClass().getName() + ".run:\n\t" + exception);
                System.err.println(this.getClass().getName() + ".run:\n\t" + exception);
                exception.printStackTrace();
            }
        }
    }

    public static void main(String[] stringArray) {
        try {
            new MainApp("ISDN Monitor for AVM ISDN Cards [2006-05-05]", stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

