/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.application.faxsender;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import uk.co.mmscomputing.application.imageviewer.ImagePanel;
import uk.co.mmscomputing.application.imageviewer.ScannerTab;
import uk.co.mmscomputing.device.fax.FaxSender;
import uk.co.mmscomputing.device.fax.FaxSenderListener;
import uk.co.mmscomputing.device.fax.FaxSenderMetadata;

public class FaxSenderTab
extends ScannerTab
implements FaxSenderListener {
    protected static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss_");

    public FaxSenderTab(Properties properties) {
        super(properties);
    }

    protected void setButtonPanel(JPanel jPanel) {
        super.setButtonPanel(jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(0, 1));
        jPanel2.add(new JButton(this.getScaleAction()));
        jPanel.add(jPanel2);
        FaxSender faxSender = FaxSender.getDevice();
        if (faxSender != null) {
            faxSender.addListener(this);
            jPanel.add(faxSender.getGUI(this.properties));
        }
    }

    public Action getScaleAction() {
        return new AbstractAction("<html><center>convert to <br><b>Fax Format</b></center></html>"){

            public void actionPerformed(ActionEvent actionEvent) {
                FaxSenderTab.this.scale();
            }
        };
    }

    public void scale() {
        for (int i = 0; i < this.images.getTabCount(); ++i) {
            Graphics2D graphics2D;
            Object object;
            JScrollPane jScrollPane = (JScrollPane)this.images.getComponentAt(i);
            ImagePanel imagePanel = (ImagePanel)jScrollPane.getViewport().getView();
            BufferedImage bufferedImage = imagePanel.getImage();
            if (1728 < bufferedImage.getWidth()) {
                double d = 1728.0 / (double)bufferedImage.getWidth();
                object = new BufferedImage(1728, (int)((double)bufferedImage.getHeight() * d), 12);
                Graphics2D graphics2D2 = ((BufferedImage)object).createGraphics();
                AffineTransform affineTransform = new AffineTransform();
                affineTransform.scale(d, d);
                graphics2D2.drawRenderedImage(bufferedImage, affineTransform);
                imagePanel.setImage((BufferedImage)object);
            } else if (bufferedImage.getWidth() < 1728) {
                BufferedImage bufferedImage2 = new BufferedImage(1728, bufferedImage.getHeight(), 12);
                graphics2D = bufferedImage2.createGraphics();
                object = new AffineTransform();
                graphics2D.setPaint(Color.white);
                graphics2D.fill(new Rectangle(0, 0, bufferedImage2.getWidth(), bufferedImage2.getHeight()));
                graphics2D.drawRenderedImage(bufferedImage, (AffineTransform)object);
                imagePanel.setImage(bufferedImage2);
            } else if (bufferedImage.getType() != 12) {
                BufferedImage bufferedImage3 = new BufferedImage(1728, bufferedImage.getHeight(), 12);
                graphics2D = bufferedImage3.createGraphics();
                object = new AffineTransform();
                graphics2D.drawRenderedImage(bufferedImage, (AffineTransform)object);
                imagePanel.setImage(bufferedImage3);
            }
            imagePanel.revalidate();
            imagePanel.repaint();
        }
    }

    public void update(FaxSenderMetadata.Type type, FaxSenderMetadata faxSenderMetadata) {
        if (type.equals(FaxSenderMetadata.GETFILE)) {
            faxSenderMetadata.setFile(this.getFile());
            faxSenderMetadata.setHeader(this.properties.getProperty("uk.co.mmscomputing.device.fax.header"));
            faxSenderMetadata.setLocalNo(this.properties.getProperty("uk.co.mmscomputing.device.fax.localno"));
            faxSenderMetadata.setRemoteNo(this.properties.getProperty("uk.co.mmscomputing.device.fax.remoteno"));
            int n = Integer.valueOf(this.properties.getProperty("uk.co.mmscomputing.device.fax.timeout"));
            faxSenderMetadata.setTimeOut(n);
            faxSenderMetadata.progressmonitor = true;
        } else if (type.equals(FaxSenderMetadata.STATE)) {
            int n = faxSenderMetadata.getState();
            switch (n) {
                case 1: {
                    System.out.println("Ringing ... " + faxSenderMetadata.getRemoteNo());
                    break;
                }
                case 2: {
                    System.out.println("Sending ... " + faxSenderMetadata.getRemoteNo());
                    break;
                }
                case 0: {
                    System.out.println("Disconnected ... " + faxSenderMetadata.getRemoteNo());
                }
            }
        } else if (type.equals(FaxSenderMetadata.INFO)) {
            System.out.println(faxSenderMetadata.getInfo());
        } else if (type.equals(FaxSenderMetadata.EXCEPTION)) {
            System.out.println("9\b" + faxSenderMetadata.getException().getMessage());
        }
    }

    private String getFile() {
        try {
            String string = sdf.format(Calendar.getInstance().getTime());
            String string2 = this.properties.getProperty("uk.co.mmscomputing.device.faxsender.dir");
            String string3 = this.properties.getProperty("uk.co.mmscomputing.device.fax.remoteno");
            String string4 = string3.replace('*', '0').replace('#', '0');
            String string5 = string2 + File.separator + string + string4 + ".sff";
            this.properties.setProperty("uk.co.mmscomputing.device.fax.file", string5);
            new File(string2).mkdirs();
            this.save(string5);
            return string5;
        }
        catch (Exception exception) {
            System.out.println("9\b" + this.getClass().getName() + ".sendFax:\n\t" + exception.getMessage());
            exception.printStackTrace();
            return null;
        }
    }
}

