/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.application.imageviewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;
import javax.imageio.IIOImage;
import javax.imageio.IIOParamController;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import uk.co.mmscomputing.application.imageviewer.ImagePanel;
import uk.co.mmscomputing.application.imageviewer.TabCloseIcon;
import uk.co.mmscomputing.image.operators.ImageTypeConvertOp;
import uk.co.mmscomputing.image.operators.ImageTypeConvertOpPanel;
import uk.co.mmscomputing.util.JarImageIcon;

public class ImageTab
extends JPanel
implements PropertyChangeListener {
    public static final String fileOpenID = "uk.co.mmscomputing.file.open.dir";
    public static final String fileSaveID = "uk.co.mmscomputing.file.save.dir";
    protected Properties properties;
    protected JTabbedPane images;
    protected JFileChooser openfc;
    protected JFileChooser savefc;

    public ImageTab(Properties properties) {
        this.properties = properties;
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 3));
        this.setButtonPanel(jPanel2);
        jPanel.add((Component)jPanel2, "North");
        this.add((Component)jPanel, "East");
        this.images = new JTabbedPane();
        this.add((Component)this.images, "Center");
        String string = System.getProperty("user.home");
        this.setOpenDir(properties.getProperty(fileOpenID, string));
        this.setSaveDir(properties.getProperty(fileSaveID, string));
    }

    public void setOpenDir(String string) {
        new File(string).mkdirs();
        this.openfc = new JFileChooser(string);
    }

    public void setSaveDir(String string) {
        new File(string).mkdirs();
        this.savefc = new JFileChooser(string);
    }

    protected void setButtonPanel(JPanel jPanel) {
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(0, 1));
        jPanel2.add(new JButton(this.getNewAction()));
        jPanel2.add(new JButton(this.getOpenAction()));
        jPanel2.add(new JButton(this.getSaveAction()));
        jPanel2.add(new JButton(this.getPrintAction()));
        jPanel2.add(new JButton(this.getConvertAction()));
        jPanel2.add(new JButton(this.getRotateAction()));
        jPanel.add(jPanel2);
    }

    public Action getNewAction() {
        return new AbstractAction("new", new JarImageIcon(this.getClass(), "32x32/new.png")){

            public void actionPerformed(ActionEvent actionEvent) {
                ImageTab.this.images.removeAll();
            }
        };
    }

    public Action getOpenAction() {
        return new AbstractAction("open", new JarImageIcon(this.getClass(), "32x32/open.png")){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = ImageTab.this.openfc.showOpenDialog(null);
                ImageTab.this.properties.setProperty(ImageTab.fileOpenID, ImageTab.this.openfc.getCurrentDirectory().toString());
                if (n == 0) {
                    try {
                        ImageTab.this.open(ImageTab.this.openfc.getSelectedFile().getPath());
                    }
                    catch (Exception exception) {
                        JOptionPane.showMessageDialog(null, "Image Open Error : " + exception.getMessage(), "Exception", 0);
                    }
                }
            }
        };
    }

    public Action getSaveAction() {
        return new AbstractAction("save", new JarImageIcon(this.getClass(), "32x32/save.png")){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = ImageTab.this.savefc.showSaveDialog(null);
                ImageTab.this.properties.setProperty(ImageTab.fileSaveID, ImageTab.this.savefc.getCurrentDirectory().toString());
                if (n == 0) {
                    new Thread(){

                        public void run() {
                            try {
                                ImageTab.this.save(ImageTab.this.savefc.getSelectedFile().getPath());
                            }
                            catch (Exception exception) {
                                JOptionPane.showMessageDialog(null, "Image Save Error : " + exception.getMessage(), "Exception", 0);
                            }
                        }
                    }.start();
                }
            }
        };
    }

    public Action getPrintAction() {
        return new AbstractAction("", new JarImageIcon(this.getClass(), "32x32/print.png")){

            public void actionPerformed(ActionEvent actionEvent) {
                new Thread(){

                    public void run() {
                        Printer printer = new Printer();
                        for (int i = 0; i < ImageTab.this.images.getTabCount(); ++i) {
                            JScrollPane jScrollPane = (JScrollPane)ImageTab.this.images.getComponentAt(i);
                            ImagePanel imagePanel = (ImagePanel)jScrollPane.getViewport().getView();
                            printer.append(imagePanel);
                        }
                        printer.print();
                    }
                }.start();
            }
        };
    }

    public Action getConvertAction() {
        return new AbstractAction("<html><center><b>Colour</b><br><b>Reduction</b></center></html>"){

            public void actionPerformed(ActionEvent actionEvent) {
                ImageTab.this.convertImage();
            }
        };
    }

    public Action getRotateAction() {
        return new AbstractAction("", new JarImageIcon(this.getClass(), "32x32/rotate.png")){

            public void actionPerformed(ActionEvent actionEvent) {
                JScrollPane jScrollPane = (JScrollPane)ImageTab.this.images.getSelectedComponent();
                if (jScrollPane != null) {
                    ImagePanel imagePanel = (ImagePanel)jScrollPane.getViewport().getView();
                    imagePanel.rotate();
                }
            }
        };
    }

    protected void addImage(String string, BufferedImage bufferedImage) {
        Object object = bufferedImage.getProperty("iiometadata");
        if (object == Image.UndefinedProperty || object == null || object instanceof IIOMetadata) {
            // empty if block
        }
        System.out.println("Image.Width =" + bufferedImage.getWidth());
        System.out.println("Image.Height =" + bufferedImage.getHeight());
        ImagePanel imagePanel = new ImagePanel();
        imagePanel.addPropertyChangeListener(this);
        JScrollPane jScrollPane = new JScrollPane(imagePanel);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(100);
        jScrollPane.getHorizontalScrollBar().setUnitIncrement(100);
        imagePanel.setImage(bufferedImage);
        this.images.addTab(string, new TabCloseIcon(), jScrollPane);
        this.images.setSelectedIndex(this.images.getTabCount() - 1);
    }

    public void open(String string) throws IOException {
        long l = System.currentTimeMillis();
        String string2 = string.substring(string.lastIndexOf(46) + 1);
        Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName(string2);
        if (!iterator.hasNext()) {
            throw new IOException(this.getClass().getName() + ".open:\n\tNo reader for format '" + string2 + "' available.");
        }
        ImageReader imageReader = iterator.next();
        while (!imageReader.getClass().getName().startsWith("uk.co.mmscomputing") && iterator.hasNext()) {
            imageReader = iterator.next();
        }
        File file = new File(string);
        ImageInputStream imageInputStream = ImageIO.createImageInputStream(file);
        try {
            imageReader.setInput(imageInputStream, true);
            try {
                int n = 0;
                while (true) {
                    IIOMetadata iIOMetadata = imageReader.getImageMetadata(n);
                    this.addImage(file.getName() + " " + n, imageReader.read(n));
                    ++n;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                imageInputStream.close();
            }
        }
        catch (Error error) {
            try {
                System.out.println("9\b" + this.getClass().getName() + ".open:\n\t" + error);
                error.printStackTrace();
                throw error;
            }
            catch (Throwable throwable) {
                imageInputStream.close();
                throw throwable;
            }
        }
        l = System.currentTimeMillis() - l;
        System.out.println("Opened : " + string);
        System.out.println("Time used to load images : " + l);
    }

    private IIOImage getIIOImage(ImageWriter imageWriter, ImageWriteParam imageWriteParam, BufferedImage bufferedImage) {
        ImageTypeSpecifier imageTypeSpecifier = ImageTypeSpecifier.createFromRenderedImage(bufferedImage);
        Object object = bufferedImage.getProperty("iiometadata");
        IIOMetadata iIOMetadata = object != null && object instanceof IIOMetadata ? (IIOMetadata)object : imageWriter.getDefaultImageMetadata(imageTypeSpecifier, imageWriteParam);
        return new IIOImage(bufferedImage, null, iIOMetadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(String string) throws IOException {
        if (this.images.getTabCount() <= 0) {
            throw new IOException(this.getClass().getName() + ".save:\n\tNo images available!");
        }
        String string2 = string.substring(string.lastIndexOf(46) + 1);
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName(string2);
        if (!iterator.hasNext()) {
            throw new IOException(this.getClass().getName() + ".save:\n\tNo writer for format '" + string2 + "' available.");
        }
        ImageWriter imageWriter = iterator.next();
        while (!imageWriter.getClass().getName().startsWith("uk.co.mmscomputing") && iterator.hasNext()) {
            imageWriter = iterator.next();
        }
        ImageWriteParam imageWriteParam = imageWriter.getDefaultWriteParam();
        IIOParamController iIOParamController = imageWriteParam.getController();
        if (iIOParamController != null) {
            iIOParamController.activate(imageWriteParam);
        }
        long l = System.currentTimeMillis();
        File file = new File(string);
        if (file.exists()) {
            file.delete();
        }
        ImageOutputStream imageOutputStream = null;
        try {
            imageOutputStream = ImageIO.createImageOutputStream(file);
            imageWriter.setOutput(imageOutputStream);
            if (imageWriter.canWriteSequence()) {
                imageWriter.prepareWriteSequence(null);
                for (int i = 0; i < this.images.getTabCount(); ++i) {
                    JScrollPane jScrollPane = (JScrollPane)this.images.getComponentAt(i);
                    ImagePanel imagePanel = (ImagePanel)jScrollPane.getViewport().getView();
                    imageWriter.writeToSequence(this.getIIOImage(imageWriter, imageWriteParam, imagePanel.getImage()), imageWriteParam);
                }
                imageWriter.endWriteSequence();
            } else {
                JScrollPane jScrollPane = (JScrollPane)this.images.getComponentAt(0);
                ImagePanel imagePanel = (ImagePanel)jScrollPane.getViewport().getView();
                imageWriter.write(null, this.getIIOImage(imageWriter, imageWriteParam, imagePanel.getImage()), imageWriteParam);
                for (int i = 1; i < this.images.getTabCount(); ++i) {
                    if (!imageWriter.canInsertImage(i)) {
                        throw new IOException("Image Writer cannot append image [" + i + "] (" + string + ")");
                    }
                    jScrollPane = (JScrollPane)this.images.getComponentAt(i);
                    imagePanel = (ImagePanel)jScrollPane.getViewport().getView();
                    imageWriter.write(null, this.getIIOImage(imageWriter, imageWriteParam, imagePanel.getImage()), imageWriteParam);
                }
            }
            l = System.currentTimeMillis() - l;
            System.out.println("Saved : " + string);
            System.out.println("3\bTime used to save images : " + l);
        }
        finally {
            if (imageOutputStream != null) {
                imageOutputStream.close();
            }
        }
    }

    public void convertImage() {
        new Thread(){

            public void run() {
                try {
                    ImageTypeConvertOpPanel imageTypeConvertOpPanel = new ImageTypeConvertOpPanel();
                    ImageTypeConvertOp imageTypeConvertOp = imageTypeConvertOpPanel.activate();
                    if (imageTypeConvertOp != null) {
                        for (int i = 0; i < ImageTab.this.images.getTabCount(); ++i) {
                            JScrollPane jScrollPane = (JScrollPane)ImageTab.this.images.getComponentAt(i);
                            ImagePanel imagePanel = (ImagePanel)jScrollPane.getViewport().getView();
                            BufferedImage bufferedImage = imageTypeConvertOp.filter(imagePanel.getImage());
                            imagePanel.setImage(bufferedImage);
                            imagePanel.revalidate();
                            imagePanel.repaint();
                            String string = "Unknown Type";
                            switch (bufferedImage.getType()) {
                                case 12: {
                                    string = "Byte Binary";
                                    break;
                                }
                                case 13: {
                                    string = "Byte Indexed";
                                }
                            }
                            ColorModel colorModel = bufferedImage.getColorModel();
                            System.out.println("9\bConverted Images to:\n\ntype: " + string + "\nbpp: " + colorModel.getPixelSize());
                        }
                    }
                }
                catch (Exception exception) {
                    System.out.println("9\b" + this.getClass().getName() + ".convertImage:\n\t" + exception);
                    exception.printStackTrace();
                }
            }
        }.start();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    private static class Printer
    extends Thread {
        PrinterJob pj = PrinterJob.getPrinterJob();
        PageFormat pf = this.pj.defaultPage();
        Book bk;

        public Printer() {
            Paper paper = this.pf.getPaper();
            paper.setImageableArea(0.0, 0.0, paper.getWidth(), paper.getHeight());
            this.pf.setPaper(paper);
            this.pf = this.pj.validatePage(this.pf);
            this.bk = new Book();
        }

        public void append(ImagePanel imagePanel) {
            this.bk.append(imagePanel, this.pf);
        }

        public void print() {
            this.pj.setPageable(this.bk);
            if (this.pj.printDialog()) {
                try {
                    this.pj.print();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    System.out.println("9\b" + this.getClass().getName() + ".print:\n\t" + exception.getMessage());
                }
            }
        }
    }
}

