/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.application.install;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class Log
extends JPanel {
    SimpleAttributeSet black = new SimpleAttributeSet();
    SimpleAttributeSet blue;
    SimpleAttributeSet red;
    JTextPane pane;
    Document doc;

    public Log() {
        StyleConstants.setForeground(this.black, Color.black);
        this.blue = new SimpleAttributeSet();
        StyleConstants.setForeground(this.blue, Color.blue);
        this.red = new SimpleAttributeSet();
        StyleConstants.setForeground(this.red, Color.red);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd--hh-mm-ss");
        String string = simpleDateFormat.format(new Date());
        this.pane = new JTextPane();
        this.pane.setFont(new Font("Courier", 0, 12));
        this.pane.setText("Log started at : " + string + "\n\n");
        this.doc = this.pane.getDocument();
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(this.pane), "Center");
    }

    private void write(String string, SimpleAttributeSet simpleAttributeSet) {
        try {
            this.doc.insertString(0, string + "\n", simpleAttributeSet);
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            System.err.println(string);
        }
    }

    public void msg(InputStream inputStream) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String string = "";
            while ((string = bufferedReader.readLine()) != null) {
                this.write(string, this.black);
            }
            inputStream.close();
        }
        catch (IOException iOException) {
            this.msg(iOException.getMessage());
        }
    }

    public void msg(String string) {
        this.write(string, this.black);
        this.repaint();
    }

    public void err(String string) {
        System.err.println(string);
        this.write(string, this.red);
        JOptionPane.showMessageDialog(null, string, "Exception", 0);
    }

    public void err(Exception exception) {
        exception.printStackTrace();
        this.write(exception.getMessage(), this.blue);
        JOptionPane.showMessageDialog(null, exception.getMessage(), "Exception", 0);
    }

    public void err(String string, Exception exception) {
        exception.printStackTrace();
        this.write(string + "\r\n" + exception.getMessage(), this.blue);
        JOptionPane.showMessageDialog(null, string + "\r\n" + exception.getMessage(), "Exception", 0);
    }
}

