/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.application.phone;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.JTableHeader;
import uk.co.mmscomputing.application.phone.PhoneBookColumnModel;
import uk.co.mmscomputing.application.phone.PhoneBookEntry;
import uk.co.mmscomputing.application.phone.PhoneBookImpl;
import uk.co.mmscomputing.application.phone.PhoneBookModel;
import uk.co.mmscomputing.device.phone.PhoneCallerListener;
import uk.co.mmscomputing.device.phone.PhoneCallerMetadata;
import uk.co.mmscomputing.util.JarImageIcon;

public class PhoneBookTab
extends JPanel
implements PropertyChangeListener,
PhoneCallerListener {
    InputPanel input;
    private Properties properties;
    private PhoneBookImpl phonebook = null;
    private PhoneBookModel model = null;
    private PhoneBookColumnModel columnmodel = null;
    JTable table;
    private int curcol = 0;

    public PhoneBookTab(Properties properties, PhoneBookImpl phoneBookImpl) throws IOException {
        this.properties = properties;
        this.phonebook = phoneBookImpl;
        this.columnmodel = new PhoneBookColumnModel();
        this.model = new PhoneBookModel();
        this.setLayout(new BorderLayout());
        this.input = new InputPanel();
        this.add((Component)this.input, "North");
        this.table = new JTable(this.model, this.columnmodel);
        this.table.createDefaultColumnsFromModel();
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectionListener());
        JTableHeader jTableHeader = this.table.getTableHeader();
        jTableHeader.setReorderingAllowed(false);
        jTableHeader.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 1) {
                    PhoneBookTab.this.buildTable(PhoneBookTab.this.table.getTableHeader().columnAtPoint(mouseEvent.getPoint()));
                    PhoneBookTab.this.table.revalidate();
                    PhoneBookTab.this.getParent().repaint();
                }
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.isMetaDown()) {
                    int n = PhoneBookTab.this.table.rowAtPoint(mouseEvent.getPoint());
                    PhoneBookTab.this.table.setRowSelectionInterval(n, n);
                    if (mouseEvent.getClickCount() == 2) {
                        PhoneBookTab.this.delete(n);
                    }
                } else if (mouseEvent.getClickCount() == 1) {
                    int n = PhoneBookTab.this.table.getSelectedRow();
                    if (n == -1) {
                        return;
                    }
                    PhoneBookTab.this.table.setRowSelectionInterval(n, n);
                    String string = (String)PhoneBookTab.this.table.getValueAt(n, 0);
                    String string2 = (String)PhoneBookTab.this.table.getValueAt(n, 1);
                    PhoneBookTab.this.input.setText(string, string2);
                }
            }
        });
        this.add((Component)new JScrollPane(this.table), "Center");
        this.buildTable(this.curcol);
    }

    private void buildTable(int n) {
        this.model.clear();
        n = n + 1 & 1;
        Set set = this.phonebook.entrySet(n);
        for (Map.Entry entry : set) {
            PhoneBookEntry phoneBookEntry = n == 0 ? new PhoneBookEntry((String)entry.getValue(), (String)entry.getKey()) : new PhoneBookEntry((String)entry.getKey(), (String)entry.getValue());
            this.model.addEntry(phoneBookEntry);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("update")) {
            JTabbedPane jTabbedPane = (JTabbedPane)this.getParent();
            jTabbedPane.setSelectedIndex(jTabbedPane.indexOfTab("Phone Book"));
            String string2 = (String)propertyChangeEvent.getNewValue();
            this.input.setText(this.phonebook.getName(string2), string2);
        }
    }

    private void save(String string, String string2) {
        int n = this.model.getRow(0, string);
        if (n != -1) {
            this.phonebook.remove((String)this.model.getValueAt(n, 1));
            this.model.removeRow(n);
        } else {
            n = this.model.getRow(1, string2);
            if (n != -1) {
                this.phonebook.remove(string2);
                this.model.removeRow(n);
            }
        }
        PhoneBookEntry phoneBookEntry = new PhoneBookEntry(string, string2);
        this.model.addEntry(phoneBookEntry);
        this.phonebook.put(string2, string);
        this.phonebook.write();
        this.buildTable(this.curcol);
        this.table.revalidate();
        this.getParent().repaint();
    }

    private void delete(int n) {
        Object[] objectArray = new Object[]{"YES", "NO"};
        String string = (String)this.table.getValueAt(n, 0);
        String string2 = (String)this.table.getValueAt(n, 1);
        int n2 = JOptionPane.showOptionDialog(null, "<html><b>Do you really want to delete entry " + string + " [" + string2 + "] ?</b><br>&nbsp;</html>", "Warning", 0, 3, null, objectArray, objectArray[0]);
        if (n2 == 0) {
            this.phonebook.remove(string2);
            this.model.removeRow(n);
            this.phonebook.write();
            this.buildTable(this.curcol);
            this.table.revalidate();
        }
    }

    public void addEntry(String string, String string2) {
        this.input.setText(string2, string);
        JTabbedPane jTabbedPane = (JTabbedPane)this.getParent();
        jTabbedPane.setSelectedIndex(jTabbedPane.indexOfTab("Phone Book"));
    }

    private InputStream getInputStream() {
        return null;
    }

    private OutputStream getOutputStream() {
        return null;
    }

    public void update(PhoneCallerMetadata.Type type, PhoneCallerMetadata phoneCallerMetadata) {
        if (type.equals(PhoneCallerMetadata.STATE)) {
            int n = phoneCallerMetadata.getState();
            switch (n) {
                case 1: {
                    phoneCallerMetadata.setLocalNo(this.properties.getProperty("uk.co.mmscomputing.device.phone.localno"));
                    phoneCallerMetadata.setRemoteNo(this.properties.getProperty("uk.co.mmscomputing.device.phone.remoteno"));
                    System.out.println("Ringing ... " + phoneCallerMetadata.getRemoteNo());
                    break;
                }
                case 2: {
                    phoneCallerMetadata.setInputStream(this.getInputStream());
                    phoneCallerMetadata.setOutputStream(this.getOutputStream());
                    System.out.println("Connected to ... " + phoneCallerMetadata.getRemoteNo());
                    break;
                }
                case 0: {
                    System.out.println("Disconnected ... " + phoneCallerMetadata.getRemoteNo());
                }
            }
        } else if (type.equals(PhoneCallerMetadata.INFO)) {
            System.out.println(phoneCallerMetadata.getInfo());
        } else if (type.equals(PhoneCallerMetadata.EXCEPTION)) {
            System.out.println("9\b" + phoneCallerMetadata.getException().getMessage());
        }
    }

    class InputPanel
    extends JPanel {
        JTextField name = new JTextField(40);
        JTextField number = new JTextField(60);

        InputPanel() {
            this.setLayout(new BorderLayout());
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridLayout(0, 2));
            JLabel jLabel = new JLabel("Name");
            jLabel.setBorder(new EtchedBorder());
            jPanel.add(jLabel);
            jPanel.add(this.name);
            jLabel = new JLabel("Phone Number");
            jLabel.setBorder(new EtchedBorder());
            jPanel.add(jLabel);
            jPanel.add(this.number);
            this.add((Component)jPanel, "Center");
            jPanel = new JPanel();
            jPanel.setLayout(new GridLayout(1, 0));
            jPanel.add(new JButton(this.getSaveAction()));
            this.add((Component)jPanel, "East");
        }

        public void setText(String string, String string2) {
            this.name.setText(string);
            this.number.setText(string2);
            PhoneBookTab.this.properties.setProperty("uk.co.mmscomputing.device.phone.remoteno", string2);
        }

        public Action getSaveAction() {
            return new AbstractAction("", new JarImageIcon(this.getClass(), "32x32/save.png")){

                public void actionPerformed(ActionEvent actionEvent) {
                    PhoneBookTab.this.save(InputPanel.this.name.getText(), InputPanel.this.number.getText());
                }
            };
        }

        public Action getCallAction() {
            return new AbstractAction("Call", new JarImageIcon(this.getClass(), "32x32/save.png")){

                public void actionPerformed(ActionEvent actionEvent) {
                    PhoneBookTab.this.save(InputPanel.this.name.getText(), InputPanel.this.number.getText());
                }
            };
        }
    }

    class SelectionListener
    implements ListSelectionListener {
        SelectionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            int n = PhoneBookTab.this.table.getSelectedRow();
            PhoneBookTab.this.table.setRowSelectionInterval(n, n);
            String string = (String)PhoneBookTab.this.table.getValueAt(n, 0);
            String string2 = (String)PhoneBookTab.this.table.getValueAt(n, 1);
            PhoneBookTab.this.input.setText(string, string2);
        }
    }
}

