/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.application.smsclient;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Properties;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import uk.co.mmscomputing.application.smsclient.SMSMsgColumnModel;
import uk.co.mmscomputing.application.smsclient.SMSMsgEntry;
import uk.co.mmscomputing.application.smsclient.SMSMsgModel;
import uk.co.mmscomputing.device.capi.CapiSMSPlugin;
import uk.co.mmscomputing.device.capi.CapiSystem;
import uk.co.mmscomputing.sms.SMSAddress;
import uk.co.mmscomputing.sms.SMSConstants;
import uk.co.mmscomputing.sms.SMSDLLEstablished;
import uk.co.mmscomputing.sms.SMSDataUnit;
import uk.co.mmscomputing.sms.SMSDeliver;
import uk.co.mmscomputing.sms.SMSLandLineChannel;
import uk.co.mmscomputing.sms.SMSMetadata;
import uk.co.mmscomputing.sms.SMSPluginHandler;
import uk.co.mmscomputing.sms.SMSPluginReceiver;
import uk.co.mmscomputing.sms.SMSReceiver;
import uk.co.mmscomputing.sms.SMSStatusReport;
import uk.co.mmscomputing.sms.SMSTimeStamp;

public class ReceiverPanel
extends JPanel
implements SMSConstants,
SMSPluginReceiver {
    private File parent;
    private Properties properties;
    private JTable table;
    private SMSMsgModel model = new SMSMsgModel();
    private SMSMsgColumnModel columnmodel = new SMSMsgColumnModel();
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss-SSS_");

    public ReceiverPanel(Properties properties) throws IOException {
        this.properties = properties;
        this.parent = new File(System.getProperty("user.home"), "mmsc" + File.separator + "sms");
        this.parent.mkdirs();
        CapiSMSPlugin capiSMSPlugin = new CapiSMSPlugin(this);
        CapiSystem.getSystem().addPlugin(capiSMSPlugin);
        this.table = new JTable(this.model, this.columnmodel);
        this.table.createDefaultColumnsFromModel();
        this.table.getTableHeader().setReorderingAllowed(false);
        this.buildCallList();
        this.table.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.isMetaDown()) {
                    int n = ReceiverPanel.this.table.rowAtPoint(new Point(mouseEvent.getX(), mouseEvent.getY()));
                    ReceiverPanel.this.table.setRowSelectionInterval(n, n);
                    if (mouseEvent.getClickCount() == 2) {
                        int[] nArray = ReceiverPanel.this.table.getSelectedRows();
                        for (int i = nArray.length - 1; i >= 0; --i) {
                            ((SMSMsgModel)ReceiverPanel.this.table.getModel()).delEntry(nArray[i]);
                        }
                        ReceiverPanel.this.table.revalidate();
                    }
                } else if (mouseEvent.getClickCount() == 2) {
                    int n = ReceiverPanel.this.table.getSelectedRow();
                    if (n == -1) {
                        return;
                    }
                    ReceiverPanel.this.table.setRowSelectionInterval(n, n);
                    try {
                        JTextPane jTextPane = new JTextPane();
                        jTextPane.setPage(new URL("file:////" + ReceiverPanel.this.model.getFile(n)));
                        JFrame jFrame = new JFrame();
                        jFrame.getContentPane().add(jTextPane);
                        jFrame.setSize(new Dimension(400, 200));
                        jFrame.setVisible(true);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(this.table), "Center");
    }

    public void update(SMSMetadata.Type type, SMSMetadata sMSMetadata) {
        try {
            if (type.equals(SMSMetadata.STATE)) {
                if (sMSMetadata.isState(1)) {
                    String string = this.getClass().getPackage().getName();
                    String string2 = this.properties.getProperty(string + ".receivingservicecentre");
                    String string3 = sMSMetadata.getRemoteNo();
                    if (string3.startsWith(string2) && (string3.endsWith("0") || string3.endsWith("1"))) {
                        sMSMetadata.setAccept(true);
                    }
                } else if (sMSMetadata.isState(2)) {
                    sMSMetadata.setHandler(new Handler());
                } else if (sMSMetadata.isState(0)) {
                    Handler handler = (Handler)sMSMetadata.getHandler();
                    File file = handler.file;
                    System.out.println("New SMS File : " + file.getAbsolutePath());
                    this.model.addEntry(this.parseFileName(file));
                    this.table.revalidate();
                }
            }
        }
        catch (Exception exception) {
            System.out.println(this.getClass().getName() + ".update:\n\t" + exception);
            exception.printStackTrace();
        }
    }

    private SMSMsgEntry parseFileName(File file) {
        String string = file.getName();
        String[] stringArray = (string = string.substring(0, string.indexOf(46))).split("_");
        String string2 = stringArray.length >= 1 ? stringArray[0] : "unknown";
        String string3 = stringArray.length >= 2 ? stringArray[1].replace('-', ':') : "unknown";
        String string4 = stringArray.length >= 3 ? stringArray[2] : "unknown";
        String string5 = stringArray.length >= 4 ? stringArray[3] : "withhold";
        String string6 = stringArray.length >= 5 ? stringArray[4] : "unknown";
        return new SMSMsgEntry(string2 + " " + string3, string4, string5, string6, file.getAbsolutePath());
    }

    protected void buildCallList() {
        String[] stringArray = this.list(this.parent, new fnf());
        for (int i = 0; i < stringArray.length; ++i) {
            File file = new File(this.parent, stringArray[i]);
            try {
                this.model.addEntry(this.parseFileName(file));
                continue;
            }
            catch (Exception exception) {
                System.out.println(this.getClass().getName() + ".parseFileName:\n\t" + exception);
                exception.printStackTrace();
            }
        }
    }

    private String[] list(File file, FilenameFilter filenameFilter) {
        Object[] objectArray = file.list(filenameFilter);
        if (objectArray == null) {
            return new String[0];
        }
        Arrays.sort(objectArray);
        return objectArray;
    }

    class fnf
    implements FilenameFilter {
        fnf() {
        }

        public boolean accept(File file, String string) {
            File file2 = new File(file, string);
            return file2.isFile() && string.endsWith(".html");
        }
    }

    private class Handler
    implements SMSReceiver,
    SMSPluginHandler {
        File file;
        String number = "";
        String time = "";

        private Handler() {
        }

        public void received(SMSDataUnit sMSDataUnit) throws IOException {
            if (sMSDataUnit instanceof SMSDeliver) {
                SMSAddress sMSAddress = (SMSAddress)sMSDataUnit.get("TP-OA");
                this.number = sMSAddress.getNumber();
                SMSTimeStamp sMSTimeStamp = (SMSTimeStamp)sMSDataUnit.get("TP-SCTS");
                this.time = sMSTimeStamp.toString();
            } else if (sMSDataUnit instanceof SMSStatusReport) {
                System.out.println(sMSDataUnit);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(String string, String string2, InputStream inputStream, OutputStream outputStream) {
            SMSLandLineChannel sMSLandLineChannel = null;
            PrintStream printStream = null;
            FileOutputStream fileOutputStream = null;
            try {
                String string3;
                String string4 = string2.replaceAll("\\*\\*", "");
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                printStream = new PrintStream(byteArrayOutputStream);
                sMSLandLineChannel = new SMSLandLineChannel(outputStream, inputStream, this);
                sMSLandLineChannel.send(new SMSDLLEstablished());
                InputStream inputStream2 = sMSLandLineChannel.getInputStream();
                byte[] byArray = new byte[256];
                int n = inputStream2.read(byArray);
                if (n != -1) {
                    string3 = "SMS from: " + this.number + " " + this.time;
                    printStream.println("<html>");
                    printStream.println("<head>");
                    printStream.println("<title>" + string3 + "</title>");
                    printStream.println("</head>");
                    printStream.println("<body><b>" + string3 + "<b>");
                    do {
                        printStream.println("<p><pre><i>");
                        printStream.write(byArray, 0, n);
                        printStream.println("</i></pre></p>");
                    } while ((n = inputStream2.read(byArray)) != -1);
                    printStream.println("</body>");
                    printStream.println("</html>");
                }
                printStream.close();
                string3 = sdf.format(new Date()) + string + "_" + string4 + "_" + this.number + ".html";
                this.file = new File(ReceiverPanel.this.parent, string3);
                fileOutputStream = new FileOutputStream(this.file);
                fileOutputStream.write(byteArrayOutputStream.toByteArray());
            }
            catch (Exception exception) {
                System.out.println("3\b" + this.getClass().getName() + ".run:\n\t" + exception);
                exception.printStackTrace();
            }
            finally {
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                    if (sMSLandLineChannel != null) {
                        sMSLandLineChannel.close();
                    }
                }
                catch (Exception exception) {
                    System.out.println("3\b" + this.getClass().getName() + ".run:\n\t" + exception);
                }
            }
        }
    }
}

