/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.concurrent;

import uk.co.mmscomputing.concurrent.Semaphore;
import uk.co.mmscomputing.concurrent.TimeUnit;
import uk.co.mmscomputing.concurrent.TimerListener;

public class Timer
extends Semaphore {
    private boolean waiting;
    protected int timeout;
    protected int delay;
    protected TimerListener listener;

    public Timer(int n) {
        super(0, true);
        this.timeout = n;
    }

    public void setDelay(int n) {
        this.delay = n;
    }

    public void setListener(TimerListener timerListener) {
        this.listener = timerListener;
    }

    public void acquire() throws InterruptedException {
        this.waiting = true;
        new CountdownThread().start();
        super.acquire();
        this.waiting = false;
    }

    public boolean tryAcquire(long l, TimeUnit timeUnit) throws InterruptedException {
        this.waiting = true;
        new CountdownThread().start();
        boolean bl = super.tryAcquire(l, timeUnit);
        this.waiting = false;
        return bl;
    }

    class CountdownThread
    extends Thread {
        CountdownThread() {
        }

        public void run() {
            int n = Timer.this.timeout;
            Timer.this.listener.begin(n);
            while (Timer.this.waiting) {
                try {
                    CountdownThread.sleep(Timer.this.delay);
                    Timer.this.listener.tick(n -= Timer.this.delay);
                }
                catch (InterruptedException interruptedException) {}
            }
            Timer.this.listener.end(n);
        }
    }
}

