/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.capi;

import java.io.IOException;
import uk.co.mmscomputing.concurrent.Semaphore;
import uk.co.mmscomputing.concurrent.TimeUnit;
import uk.co.mmscomputing.device.capi.CapiApplication;
import uk.co.mmscomputing.device.capi.CapiChannel;
import uk.co.mmscomputing.device.capi.CapiController;
import uk.co.mmscomputing.device.capi.CapiNCC;
import uk.co.mmscomputing.device.capi.CapiPLC;
import uk.co.mmscomputing.device.capi.ctrl.ConnectReq;
import uk.co.mmscomputing.device.capi.exception.CapiException;
import uk.co.mmscomputing.device.capi.exception.CapiIOException;
import uk.co.mmscomputing.device.capi.exception.CapiInformation;
import uk.co.mmscomputing.device.capi.protocol.BProtocol;
import uk.co.mmscomputing.device.capi.protocol.FaxBProtocol;
import uk.co.mmscomputing.device.capi.protocol.SpeechProtocol;
import uk.co.mmscomputing.util.metadata.Metadata;

public class CapiCallApplication
extends CapiApplication {
    public CapiCallApplication(Metadata metadata) throws CapiException {
        super(metadata);
    }

    public CapiChannel connect(ConnectReq connectReq, Semaphore semaphore, long l) throws IOException {
        int n;
        if (semaphore == null) {
            throw new CapiInformation(this.getClass().getName() + ".connect:\n\tConnection request timed out.");
        }
        CapiPLC capiPLC = this.newPLC(connectReq);
        capiPLC.setPickupBlocker(semaphore);
        this.put(connectReq);
        try {
            if (l < 3000L) {
                l = 3000L;
            }
            semaphore.tryAcquire(l, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            CapiNCC capiNCC = capiPLC.getNCC();
            if (capiNCC.isOpen()) {
                return capiNCC;
            }
            capiPLC.close();
            n = capiNCC.getDisconnectReason();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            capiPLC.close();
            n = capiPLC.getDisconnectReason();
        }
        if (n == 13456) {
            throw new CapiInformation(this.getClass().getName() + ".connect:\n\tConnection request timed out.");
        }
        throw new CapiIOException(n);
    }

    public CapiChannel connect(ConnectReq connectReq, long l) throws IOException {
        return this.connect(connectReq, new Semaphore(0, true), l);
    }

    public CapiChannel connect(String string, Semaphore semaphore, long l, BProtocol bProtocol) throws IOException {
        String string2 = this.md.getString("capi.localno");
        ConnectReq connectReq = new ConnectReq(this.appid, this.getControllerId(), 1, string, string2, "", "", bProtocol);
        return this.connect(connectReq, semaphore, l);
    }

    public CapiChannel connect(String string, long l, BProtocol bProtocol) throws IOException {
        return this.connect(string, new Semaphore(0, true), l, bProtocol);
    }

    public CapiChannel connect(String string, long l) throws IOException {
        int n = this.md.getInt("capi.bandwidth");
        return this.connect(string, l, new SpeechProtocol(n));
    }

    public CapiChannel faxconnect(String string, Semaphore semaphore, long l, String string2) throws IOException {
        CapiController capiController = this.getController();
        if (!capiController.isSupportingGroup3Fax()) {
            throw new CapiException(this.getClass().getName() + ".faxconnect:\n\tController [" + capiController.getId() + "] does not support fax T.30 protocol.");
        }
        String string3 = this.md.getString("capi.localno");
        return this.connect(string, semaphore, l, new FaxBProtocol(0, 0, string3, string2));
    }

    public CapiChannel faxconnect(String string, long l, String string2) throws IOException {
        return this.faxconnect(string, new Semaphore(0, true), l, string2);
    }

    public CapiChannel faxconnect(String string, Semaphore semaphore, long l, String string2, String string3) throws IOException {
        CapiController capiController = this.getController();
        if (!capiController.isSupportingGroup3Fax()) {
            throw new CapiException(this.getClass().getName() + ".faxconnect:\n\tController [" + capiController.getId() + "] does not support fax T.30 protocol.");
        }
        return this.connect(string, semaphore, l, new FaxBProtocol(0, 0, string2, string3));
    }

    public CapiChannel faxconnect(String string, long l, String string2, String string3) throws IOException {
        return this.faxconnect(string, new Semaphore(0, true), l, string2, string3);
    }
}

