/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.capi;

import uk.co.mmscomputing.device.capi.CapiChannel;
import uk.co.mmscomputing.device.capi.CapiController;
import uk.co.mmscomputing.device.capi.CapiEnumerator;
import uk.co.mmscomputing.device.capi.CapiNCC;

public class CapiFaxDetector
extends Thread {
    CapiChannel channel;

    public CapiFaxDetector(CapiChannel capiChannel) {
        this.channel = capiChannel;
    }

    public void run() {
        Thread.currentThread().setName(this.getClass().getName() + ".0x" + Integer.toHexString(this.channel.getLineID()));
        try {
            CapiController capiController = CapiEnumerator.getController(this.channel);
            if (capiController.isSupportingDTMF()) {
                this.channel.startDTMF();
                String string = this.channel.getDTMFDigits(3, 30000);
                this.channel.stopDTMF();
                if (string.startsWith("XXX")) {
                    if (capiController.isSupportingGroup3Fax()) {
                        ((CapiNCC)this.channel).selectFaxProtocol();
                    } else {
                        System.out.println("3\bController " + capiController.getName() + " does not support Group 3 FAX. Handle as sound data.");
                    }
                }
            } else {
                System.out.println("3\bController " + capiController.getName() + " does not support DTMF detection. Handle as sound data.");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

