/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.capi;

import java.io.IOException;
import java.io.InputStream;
import uk.co.mmscomputing.concurrent.Semaphore;
import uk.co.mmscomputing.device.capi.CapiNCC;
import uk.co.mmscomputing.device.capi.exception.CapiException;
import uk.co.mmscomputing.device.capi.ncc.DataB3Ind;
import uk.co.mmscomputing.device.capi.ncc.DataB3Resp;

public class CapiInputStream
extends InputStream {
    private CapiNCC ncc;
    private boolean isopen = true;
    private byte[] buf = null;
    private int count = 0;
    private int max = 0;
    private int available = 0;
    private Semaphore blocker = new Semaphore(0, true);
    private int indexOut = 0;
    private int indexIn = 0;
    private DataB3Ind[] dataB3Inds = new DataB3Ind[8];

    public CapiInputStream(CapiNCC capiNCC) {
        this.ncc = capiNCC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void received(DataB3Ind dataB3Ind) throws CapiException {
        if (this.isopen) {
            DataB3Ind[] dataB3IndArray = this.dataB3Inds;
            synchronized (this.dataB3Inds) {
                this.dataB3Inds[this.indexIn] = dataB3Ind;
                this.indexIn = (this.indexIn + 1) % 8;
                this.available += dataB3Ind.getPayloadLength();
                // ** MonitorExit[var2_2] (shouldn't be in output)
                this.blocker.release();
            }
        } else {
            this.sendDataResp(dataB3Ind.appid, dataB3Ind.lineid, dataB3Ind.getHandle());
        }
    }

    void disconnect() {
        if (this.isopen) {
            this.isopen = false;
            this.blocker.release();
        }
    }

    void sendDataResp(int n, int n2, int n3) throws CapiException {
        this.ncc.sendDataResp(new DataB3Resp(n, n2, n3));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readNextBuffer() throws IOException {
        if (!this.isopen) {
            return null;
        }
        try {
            this.blocker.acquire();
        }
        catch (InterruptedException interruptedException) {
            this.isopen = false;
        }
        if (!this.isopen) {
            this.blocker.release();
            return null;
        }
        DataB3Ind[] dataB3IndArray = this.dataB3Inds;
        synchronized (this.dataB3Inds) {
            DataB3Ind dataB3Ind = this.dataB3Inds[this.indexOut];
            this.indexOut = (this.indexOut + 1) % 8;
            this.count = 0;
            this.max = dataB3Ind.getPayloadLength();
            this.available -= this.max;
            // ** MonitorExit[var2_3] (shouldn't be in output)
            this.buf = dataB3Ind.getPayload(this.buf);
            this.sendDataResp(dataB3Ind.appid, dataB3Ind.lineid, dataB3Ind.getHandle());
            return this.buf;
        }
    }

    public int read() throws IOException {
        if (this.count == this.max) {
            this.buf = this.readNextBuffer();
            if (this.buf == null) {
                return -1;
            }
        }
        return 0xFF & this.buf[this.count++];
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException(this.getClass().getName() + ".read(byte[] b, int off, int len): b is null");
        }
        if (n < 0 || n2 < 0 || byArray.length < n + n2) {
            throw new IndexOutOfBoundsException(this.getClass().getName() + ".read(byte[] b, int off, int len): index off [" + n + "] or len [" + n2 + "] out of bounds [" + byArray.length + "].");
        }
        int n3 = 0;
        while (n3 < n2) {
            int n4;
            int n5;
            if (this.count == this.max) {
                this.buf = this.readNextBuffer();
                if (this.buf == null) {
                    return n3 != 0 ? n3 : -1;
                }
            }
            int n6 = (n5 = n2 - n3) < (n4 = this.max - this.count) ? n5 : n4;
            System.arraycopy(this.buf, this.count, byArray, n + n3, n6);
            n3 += n6;
            this.count += n6;
        }
        return n3;
    }

    public synchronized int available() throws IOException {
        return this.available + this.max - this.count;
    }

    public boolean isOpen() {
        return this.isopen;
    }

    public void close() throws IOException {
        if (this.isopen) {
            this.isopen = false;
            this.blocker.release();
            this.ncc.closedInput();
        }
    }
}

