/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.capi;

import java.io.IOException;
import uk.co.mmscomputing.concurrent.Semaphore;
import uk.co.mmscomputing.device.capi.CapiApplication;
import uk.co.mmscomputing.device.capi.CapiChannel;
import uk.co.mmscomputing.device.capi.CapiInputStream;
import uk.co.mmscomputing.device.capi.CapiOutputStream;
import uk.co.mmscomputing.device.capi.exception.CapiException;
import uk.co.mmscomputing.device.capi.ncc.ConnectB3ActiveInd;
import uk.co.mmscomputing.device.capi.ncc.ConnectB3Conf;
import uk.co.mmscomputing.device.capi.ncc.ConnectB3Ind;
import uk.co.mmscomputing.device.capi.ncc.DataB3Conf;
import uk.co.mmscomputing.device.capi.ncc.DataB3Ind;
import uk.co.mmscomputing.device.capi.ncc.DataB3Req;
import uk.co.mmscomputing.device.capi.ncc.DataB3Resp;
import uk.co.mmscomputing.device.capi.ncc.DisconnectB3Ind;
import uk.co.mmscomputing.device.capi.ncc.DisconnectB3Req;

public class CapiNCC
extends CapiChannel {
    protected CapiInputStream in;
    protected CapiOutputStream out;
    private boolean outgoing;
    private int reason = -1;
    private Semaphore ds = new Semaphore(0, true);

    CapiNCC(CapiApplication capiApplication, ConnectB3Conf connectB3Conf) {
        super(capiApplication, connectB3Conf.lineid);
        this.outgoing = true;
        this.in = new CapiInputStream(this);
        this.out = new CapiOutputStream(this);
    }

    CapiNCC(CapiApplication capiApplication, ConnectB3Ind connectB3Ind) {
        super(capiApplication, connectB3Ind.lineid);
        this.outgoing = false;
        this.in = new CapiInputStream(this);
        this.out = new CapiOutputStream(this);
    }

    boolean isOutgoing() {
        return this.outgoing;
    }

    boolean isIncoming() {
        return !this.outgoing;
    }

    void received(ConnectB3ActiveInd connectB3ActiveInd) {
        if (this.checkIsNotConnected()) {
            // empty if block
        }
    }

    void received(DataB3Ind dataB3Ind) throws CapiException {
        if (this.isConnected()) {
            this.in.received(dataB3Ind);
        } else {
            this.appl.put(new DataB3Resp(dataB3Ind.appid, dataB3Ind.lineid, dataB3Ind.getHandle()));
        }
    }

    void sendDataResp(DataB3Resp dataB3Resp) throws CapiException {
        this.appl.put(dataB3Resp);
    }

    void received(DataB3Conf dataB3Conf) throws CapiException {
        this.out.received(dataB3Conf);
    }

    void disconnect(int n) throws CapiException {
        this.reason = n == 0 ? 13328 : n;
        this.checkIsNotDisconnected();
        this.in.disconnect();
        this.out.disconnect();
        this.ds.release();
    }

    int getDisconnectReason() {
        return this.reason;
    }

    void received(DisconnectB3Ind disconnectB3Ind) throws CapiException {
        this.reason = disconnectB3Ind.getReason();
        this.disconnect(this.reason);
    }

    void selectFaxProtocol() throws CapiException {
        this.appl.getPLC(this.lineid & 0xFFFF).selectFaxProtocol();
    }

    public CapiInputStream getInputStream() throws IOException {
        return this.in;
    }

    public CapiOutputStream getOutputStream() throws IOException {
        return this.out;
    }

    DataB3Req write(int n, byte[] byArray, int n2) throws IOException {
        DataB3Req dataB3Req = new DataB3Req(this.applid, this.lineid, n, 0, byArray, n2);
        this.appl.put(dataB3Req);
        return dataB3Req;
    }

    private void activeDisconnect() throws CapiException {
        if (this.checkIsNotDisconnected()) {
            this.appl.put(new DisconnectB3Req(this.applid, this.lineid));
        }
        try {
            this.ds.acquire();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.ds.release();
    }

    void closedInput() throws IOException {
        if (this.out.isOpen()) {
            return;
        }
        this.activeDisconnect();
    }

    void closedOutput() throws IOException {
        if (this.in.isOpen()) {
            return;
        }
        this.activeDisconnect();
    }

    public void close() throws IOException {
        if (this.checkIsOpen()) {
            this.in.close();
            this.out.close();
        }
    }
}

