/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.capi;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import uk.co.mmscomputing.concurrent.Semaphore;
import uk.co.mmscomputing.device.capi.CapiApplication;
import uk.co.mmscomputing.device.capi.CapiChannel;
import uk.co.mmscomputing.device.capi.CapiInputStream;
import uk.co.mmscomputing.device.capi.CapiNCC;
import uk.co.mmscomputing.device.capi.CapiOutputStream;
import uk.co.mmscomputing.device.capi.CapiPlugin;
import uk.co.mmscomputing.device.capi.ctrl.ConnectReq;
import uk.co.mmscomputing.device.capi.exception.CapiException;
import uk.co.mmscomputing.device.capi.facility.DTMFConf;
import uk.co.mmscomputing.device.capi.facility.DTMFInd;
import uk.co.mmscomputing.device.capi.facility.EchoCancellerConf;
import uk.co.mmscomputing.device.capi.facility.EchoCancellerReq;
import uk.co.mmscomputing.device.capi.facility.FacilityConf;
import uk.co.mmscomputing.device.capi.facility.FacilityInd;
import uk.co.mmscomputing.device.capi.facility.FacilityResp;
import uk.co.mmscomputing.device.capi.facility.SupServiceConf;
import uk.co.mmscomputing.device.capi.facility.SupServiceInd;
import uk.co.mmscomputing.device.capi.facility.SupServiceReq;
import uk.co.mmscomputing.device.capi.facility.SupServiceResp;
import uk.co.mmscomputing.device.capi.ncc.ConnectB3Conf;
import uk.co.mmscomputing.device.capi.ncc.ConnectB3Ind;
import uk.co.mmscomputing.device.capi.plc.ConnectActiveInd;
import uk.co.mmscomputing.device.capi.plc.ConnectB3Req;
import uk.co.mmscomputing.device.capi.plc.ConnectInd;
import uk.co.mmscomputing.device.capi.plc.DisconnectInd;
import uk.co.mmscomputing.device.capi.plc.DisconnectReq;
import uk.co.mmscomputing.device.capi.plc.SelectBProtocolReq;
import uk.co.mmscomputing.device.capi.protocol.BProtocol;
import uk.co.mmscomputing.device.capi.protocol.FaxBProtocol;

public class CapiPLC
extends CapiChannel {
    private boolean ischangingprotocols = false;
    private boolean outgoing = false;
    private Vector nccs = new Vector();
    private int msgno = 0;
    private int reason = -1;
    private Semaphore ds = new Semaphore(0, true);
    private int isonhold = 0;

    public CapiPLC(CapiApplication capiApplication, ConnectInd connectInd) {
        super(capiApplication, connectInd.lineid);
        this.outgoing = false;
        this.isopen = true;
    }

    public CapiPLC(CapiApplication capiApplication, ConnectReq connectReq) {
        super(capiApplication, 0);
        this.outgoing = true;
        this.isopen = true;
        this.msgno = connectReq.msgno;
    }

    int getMsgno() {
        return this.msgno;
    }

    void setLineid(int n) {
        this.lineid = n;
    }

    public CapiNCC getNCC(int n) throws CapiException {
        Object object = this.nccs.elements();
        while (object.hasMoreElements()) {
            CapiNCC capiNCC = (CapiNCC)object.nextElement();
            if (capiNCC.getLineID() != n) continue;
            return capiNCC;
        }
        object = new CapiException(this.getClass().getName() + ".getNCC(0x" + Integer.toHexString(n) + ")\n\tCannot find NCC.");
        ((Throwable)object).printStackTrace();
        throw object;
    }

    public CapiNCC getNCC() {
        return (CapiNCC)this.nccs.get(0);
    }

    private void addNCC(CapiNCC capiNCC) {
        this.nccs.add(capiNCC);
        capiNCC.setProtocol(this.protocol);
        capiNCC.setSpeechCoding(this.getSpeechCoding());
        capiNCC.setLocalNo(this.getLocalNo());
        capiNCC.setRemoteNo(this.getRemoteNo());
        capiNCC.setPlugin(this.getPlugin());
        capiNCC.setPickupBlocker(this.getPickupBlocker());
    }

    CapiNCC addNCC(ConnectB3Ind connectB3Ind) {
        CapiNCC capiNCC = new CapiNCC(this.appl, connectB3Ind);
        this.addNCC(capiNCC);
        return capiNCC;
    }

    CapiNCC addNCC(ConnectB3Conf connectB3Conf) {
        CapiNCC capiNCC = new CapiNCC(this.appl, connectB3Conf);
        this.addNCC(capiNCC);
        return capiNCC;
    }

    void remove(CapiNCC capiNCC) throws CapiException {
        this.nccs.remove(capiNCC);
        if (this.nccs.isEmpty()) {
            if (this.ischangingprotocols) {
                this.ischangingprotocols = false;
                this.appl.put(new SelectBProtocolReq(this.applid, this.lineid, this.protocol));
            } else if (this.isonhold != 1) {
                this.activeDisconnect();
            }
        }
    }

    public CapiInputStream getInputStream(int n) throws IOException {
        return this.getNCC(n).getInputStream();
    }

    public CapiOutputStream getOutputStream(int n) throws IOException {
        return this.getNCC(n).getOutputStream();
    }

    public CapiInputStream getInputStream() throws IOException {
        return ((CapiNCC)this.nccs.get(0)).getInputStream();
    }

    public CapiOutputStream getOutputStream() throws IOException {
        return ((CapiNCC)this.nccs.get(0)).getOutputStream();
    }

    void received(ConnectActiveInd connectActiveInd) throws CapiException {
        if (this.outgoing) {
            this.appl.put(new ConnectB3Req(connectActiveInd.appid, connectActiveInd.lineid));
        }
    }

    int getDisconnectReason() {
        return this.reason;
    }

    void received(DisconnectInd disconnectInd) throws CapiException {
        this.isonhold = 0;
        this.reason = disconnectInd.getErrNo();
        if (this.checkIsNotDisconnected()) {
            CapiNCC[] capiNCCArray = this.nccs.toArray(new CapiNCC[0]);
            for (int i = 0; i < capiNCCArray.length; ++i) {
                capiNCCArray[i].disconnect(this.reason);
                this.nccs.remove(capiNCCArray[i]);
            }
        }
        this.ds.release();
        this.releasePickupBlocker();
    }

    public void selectProtocol(BProtocol bProtocol) throws CapiException {
        if (this.isopen) {
            this.ischangingprotocols = true;
            this.protocol = bProtocol;
            CapiNCC[] capiNCCArray = this.nccs.toArray(new CapiNCC[0]);
            for (int i = 0; i < capiNCCArray.length; ++i) {
                try {
                    capiNCCArray[i].setChangedProtocol(true);
                    capiNCCArray[i].close();
                    continue;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    public void selectFaxProtocol() throws CapiException {
        this.selectProtocol(new FaxBProtocol(0, 0, "", ""));
    }

    private void activeDisconnect() throws CapiException {
        if (this.checkIsNotDisconnected()) {
            this.appl.put(new DisconnectReq(this.applid, this.lineid));
        }
    }

    public void close() throws IOException {
        if (this.checkIsOpen()) {
            CapiNCC[] capiNCCArray = this.nccs.toArray(new CapiNCC[0]);
            for (int i = 0; i < capiNCCArray.length; ++i) {
                try {
                    capiNCCArray[i].close();
                    continue;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            this.activeDisconnect();
        }
        try {
            this.ds.acquire();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.ds.release();
    }

    public boolean isOnHold() {
        while (this.isonhold == 1) {
            try {
                Thread.currentThread();
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
        return this.isonhold == 2;
    }

    public boolean hold() throws CapiException {
        if (this.isonhold == 0) {
            this.isonhold = 1;
            this.appl.put(new SupServiceReq.HoldReq(this.applid, this.lineid));
        }
        return this.isOnHold();
    }

    public boolean retrieve() throws CapiException {
        if (this.isonhold == 2) {
            this.isonhold = 1;
            this.appl.put(new SupServiceReq.RetrieveReq(this.applid, this.lineid));
        }
        return !this.isOnHold();
    }

    public CapiChannel retrieveChannel() throws CapiException {
        if (this.isDisconnected()) {
            return null;
        }
        if (!this.isOnHold()) {
            this.put(new ConnectB3Req(this.applid, this.lineid));
            while (this.nccs.size() == 0) {
                try {
                    Thread.currentThread();
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
            }
        }
        return this.getNCC();
    }

    public void explicitCallTransferTo(CapiPLC capiPLC) throws CapiException {
        if (!this.hold()) {
            throw new CapiException("Explicit Call Transfer: Cannot put call on hold.");
        }
        CapiNCC[] capiNCCArray = this.nccs.toArray(new CapiNCC[0]);
        for (int i = 0; i < capiNCCArray.length; ++i) {
            try {
                capiNCCArray[i].close();
                continue;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        SupServiceReq.ECTReq eCTReq = new SupServiceReq.ECTReq(this.applid, capiPLC.getLineID(), this.getLineID());
        this.appl.put(eCTReq);
    }

    void received(SupServiceInd supServiceInd) throws CapiException {
        if (supServiceInd instanceof SupServiceInd.HoldInd) {
            this.appl.put(new SupServiceResp.HoldResp(supServiceInd.appid, supServiceInd.lineid));
            this.isonhold = ((SupServiceInd.HoldInd)supServiceInd).getReason() == 0 ? 2 : 0;
        } else if (supServiceInd instanceof SupServiceInd.RetrieveInd) {
            this.appl.put(new SupServiceResp.RetrieveResp(supServiceInd.appid, supServiceInd.lineid));
            this.isonhold = ((SupServiceInd.RetrieveInd)supServiceInd).getReason() == 0 ? 0 : 2;
        }
    }

    void received(SupServiceConf supServiceConf) throws CapiException {
        if (supServiceConf instanceof SupServiceConf.HoldConf) {
            this.isonhold = ((SupServiceConf.HoldConf)supServiceConf).getInfo() == 0 ? 1 : 0;
        } else if (supServiceConf instanceof SupServiceConf.RetrieveConf) {
            // empty if block
        }
    }

    void received(FacilityInd facilityInd) throws CapiException {
        if (facilityInd instanceof DTMFInd) {
            this.appl.put(new FacilityResp(facilityInd.appid, facilityInd.lineid, facilityInd.getSelector()));
            Enumeration enumeration = this.nccs.elements();
            while (enumeration.hasMoreElements()) {
                ((CapiNCC)enumeration.nextElement()).receivedDTMFInd((DTMFInd)facilityInd);
            }
        } else if (facilityInd instanceof SupServiceInd) {
            this.received((SupServiceInd)facilityInd);
        } else {
            this.appl.put(new FacilityResp(facilityInd.appid, facilityInd.lineid, facilityInd.getSelector()));
            System.err.println(facilityInd);
            new Exception().printStackTrace();
        }
    }

    void received(FacilityConf facilityConf) throws CapiException {
        if (facilityConf instanceof DTMFConf) {
            Enumeration enumeration = this.nccs.elements();
            while (enumeration.hasMoreElements()) {
                ((CapiNCC)enumeration.nextElement()).receivedDTMFConf((DTMFConf)facilityConf);
            }
        } else if (facilityConf instanceof SupServiceConf) {
            this.received((SupServiceConf)facilityConf);
        } else if (facilityConf instanceof EchoCancellerConf.GetSupportedServicesConf) {
            EchoCancellerConf.GetSupportedServicesConf getSupportedServicesConf = (EchoCancellerConf.GetSupportedServicesConf)facilityConf;
            this.appl.put(new EchoCancellerReq.EnableReq(facilityConf.appid, facilityConf.lineid, getSupportedServicesConf.getOptions(), getSupportedServicesConf.getMaxTailLength(), getSupportedServicesConf.getMaxPreDelay()));
        }
    }

    public void setPlugin(CapiPlugin capiPlugin) {
        super.setPlugin(capiPlugin);
        Enumeration enumeration = this.nccs.elements();
        while (enumeration.hasMoreElements()) {
            ((CapiNCC)enumeration.nextElement()).setPlugin(capiPlugin);
        }
    }
}

