/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.capi;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;
import uk.co.mmscomputing.device.capi.CapiChannel;
import uk.co.mmscomputing.device.capi.CapiSystem;
import uk.co.mmscomputing.device.capi.sound.PCMInputStream;
import uk.co.mmscomputing.device.capi.sound.PCMOutputStream;
import uk.co.mmscomputing.device.phone.PhoneCaller;
import uk.co.mmscomputing.device.phone.PhoneCallerMetadata;
import uk.co.mmscomputing.sound.SoundMixerEnumerator;

public class CapiPhoneCaller
extends PhoneCaller {
    private boolean active = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void call() throws IOException {
        SourceDataLine sourceDataLine;
        TargetDataLine targetDataLine;
        try {
            targetDataLine = SoundMixerEnumerator.getInputLine(pcmformat, 512);
            try {
                sourceDataLine = SoundMixerEnumerator.getOutputLine(pcmformat, 512);
            }
            catch (LineUnavailableException lineUnavailableException) {
                targetDataLine.close();
                throw new IOException(this.getClass().getName() + ".call:\n\t" + lineUnavailableException.getMessage());
            }
        }
        catch (LineUnavailableException lineUnavailableException) {
            throw new IOException(this.getClass().getName() + ".call:\n\t" + lineUnavailableException.getMessage());
        }
        this.md.setState(1);
        this.fireListenerUpdate(PhoneCallerMetadata.STATE);
        String string = this.md.getRemoteNo();
        int n = this.md.getTimeOut();
        System.out.println("calling rno=" + string);
        System.err.println("calling rno=" + string);
        try {
            CapiSystem capiSystem = CapiSystem.getSystem();
            CapiChannel capiChannel = capiSystem.getCaller().connect(string, (long)(n * 1000));
            this.md.setState(2);
            this.fireListenerUpdate(PhoneCallerMetadata.STATE);
            this.md.setInfo("Connected ...");
            this.fireListenerUpdate(PhoneCallerMetadata.INFO);
            try {
                int n2;
                this.active = true;
                byte[] byArray = new byte[512];
                PCMOutputStream pCMOutputStream = capiChannel.getPCMOutputStream();
                final PCMInputStream pCMInputStream = capiChannel.getPCMInputStream();
                OutputStream outputStream = this.md.getOutputStream();
                InputStream inputStream = this.md.getInputStream();
                new Thread(){

                    public void run() {
                        byte[] byArray = new byte[512];
                        try {
                            int n;
                            sourceDataLine.flush();
                            sourceDataLine.start();
                            sourceDataLine.flush();
                            while (CapiPhoneCaller.this.active && (n = pCMInputStream.read(byArray)) != -1) {
                                sourceDataLine.write(byArray, 0, n);
                            }
                            CapiPhoneCaller.this.active = false;
                            pCMInputStream.close();
                            sourceDataLine.flush();
                            sourceDataLine.stop();
                            sourceDataLine.flush();
                            sourceDataLine.close();
                        }
                        catch (Exception exception) {
                            System.out.println("9\b" + this.getClass().getName() + ".call:\n\t" + exception);
                            exception.printStackTrace();
                        }
                    }
                }.start();
                targetDataLine.flush();
                targetDataLine.start();
                targetDataLine.flush();
                while (this.active && (n2 = targetDataLine.read(byArray, 0, 512)) != -1) {
                    ((OutputStream)pCMOutputStream).write(byArray, 0, n2);
                }
                this.active = false;
                ((OutputStream)pCMOutputStream).close();
                targetDataLine.flush();
                targetDataLine.stop();
                targetDataLine.flush();
                targetDataLine.close();
            }
            catch (Exception exception) {
                System.out.println("9\b" + this.getClass().getName() + ".call:\n\t" + exception);
                exception.printStackTrace();
            }
            finally {
                capiChannel.close();
            }
        }
        catch (Exception exception) {
            System.out.println("9\b" + this.getClass().getName() + ".call:\n\tCall could not been established.\n\t" + exception);
        }
        this.md.setState(0);
        this.fireListenerUpdate(PhoneCallerMetadata.STATE);
    }

    public boolean isAPIInstalled() {
        return true;
    }

    public static PhoneCaller getDevice() {
        try {
            return new CapiPhoneCaller();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

