/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.capi;

import javax.swing.tree.DefaultMutableTreeNode;

public class CapiProfile {
    public static final String[] optionStrings = new String[]{"Internal controller", "External equipment", "Handset", "DTMF", "Supplementary Services", "Channel allocation", "Parameter B channel operation", "Line interconnect", "Broadband extensions (Eicon only ?)", "Echo cancellation (Eicon only ?)", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""};
    public static final String[] b1protocolStrings = new String[]{"64 kbits/s with HDLC framing", "64 kbits/s bit-transparent", "V.110 asynchronous", "V.110 synchronous", "T.30 modem for Group 3 fax", "64 kbits/s inverted with HDLC framing", "56 kbits/s bit-transparent", "modem with all negotiations", "modem asynchronous", "modem synchronous", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "DSL:ATM (AVM only ?)", "", "", ""};
    public static final String[] b2protocolStrings = new String[]{"ISO 7776 (X.75 SLP)", "Transparent", "SDLC", "LAPD in accordance with Q.921 for D-channel X.25 (SAPI 16)", "T.30 for Group 3 fax", "Point to point (PPP)", "Transparent (ignoring framing errors of B1 protocol)", "Modem error correction and compression (V.42bis or MNP5)", "ISO 7776 (X.75 SLP) modified supporting V.42bis compression", "V.120 asynchronous mode", "V.120 asynchronous mode supporting V.42bis", "V.120 bit-transparent mode", "LAPD in accordance with Q.921 including free SAPI selection", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "DSL:PPPOE (AVM only ?)", ""};
    public static final String[] b3protocolStrings = new String[]{"Transparent", "T.90NL", "ISO 8208 (X.25 DTE-DTE)", "X.25 DCE", "T.30 for Group 3 fax", "T.30 for Group 3 fax with extensions", "", "Modem", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "DSL:PPPOE (AVM only ?)", ""};
    private int noc = 0;
    private int noBChannels = -1;
    private int options = 0;
    private int b1protocols = 0;
    private int b2protocols = 0;
    private int b3protocols = 0;

    public CapiProfile(byte[] byArray) {
        this.noc = byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8;
        this.noBChannels = byArray[2] & 0xFF | (byArray[3] & 0xFF) << 8;
        this.options = byArray[4] & 0xFF | (byArray[5] & 0xFF) << 8 | (byArray[6] & 0xFF) << 16 | (byArray[7] & 0xFF) << 24;
        this.b1protocols = byArray[8] & 0xFF | (byArray[9] & 0xFF) << 8 | (byArray[10] & 0xFF) << 16 | (byArray[11] & 0xFF) << 24;
        this.b2protocols = byArray[12] & 0xFF | (byArray[13] & 0xFF) << 8 | (byArray[14] & 0xFF) << 16 | (byArray[15] & 0xFF) << 24;
        this.b3protocols = byArray[16] & 0xFF | (byArray[17] & 0xFF) << 8 | (byArray[18] & 0xFF) << 16 | (byArray[19] & 0xFF) << 24;
    }

    public int getNoOfBChannels() {
        return this.noBChannels;
    }

    protected boolean checkBit(int n, int n2) {
        return (n & 1 << n2) != 0;
    }

    public boolean isSupportingDTMF() {
        return this.checkBit(this.options, 3);
    }

    public boolean isSupportingGroup3Fax() {
        return this.checkBit(this.b1protocols, 4) && this.checkBit(this.b2protocols, 4) && this.checkBit(this.b3protocols, 4);
    }

    public boolean isSupportingSupplementaryServices() {
        return this.checkBit(this.options, 4);
    }

    public int getOptions() {
        return this.options;
    }

    public int getB1Protocols() {
        return this.b1protocols;
    }

    public int getB2Protocols() {
        return this.b2protocols;
    }

    public int getB3Protocols() {
        return this.b3protocols;
    }

    public String toString() {
        String string = "";
        string = string + "BChannels : " + this.noBChannels + "\n";
        string = string + "\n" + this.getGlobalOptions();
        string = string + "\n" + this.getB1ProtocolSupport();
        string = string + "\n" + this.getB2ProtocolSupport();
        string = string + "\n" + this.getB3ProtocolSupport();
        return string;
    }

    private String getGlobalOptions() {
        String string = "Options : 0" + Integer.toBinaryString(this.options) + "b\n";
        for (int i = 0; i < optionStrings.length; ++i) {
            if (!this.checkBit(this.options, i)) continue;
            string = string + "Bit[" + i + "] - " + optionStrings[i] + "\n";
        }
        return string;
    }

    public boolean isSupportingBroadband() {
        return this.checkBit(this.options, 8);
    }

    public boolean isSupportingEchoCancellation() {
        return this.checkBit(this.options, 9);
    }

    private String getB1ProtocolSupport() {
        String string = "B1 protocol support : 0" + Integer.toBinaryString(this.b1protocols) + "b\n";
        for (int i = 0; i < b1protocolStrings.length; ++i) {
            if (!this.checkBit(this.b1protocols, i)) continue;
            string = string + "Bit[" + i + "] - " + b1protocolStrings[i] + "\n";
        }
        return string;
    }

    private String getB2ProtocolSupport() {
        String string = "B2 protocol support : 0" + Integer.toBinaryString(this.b2protocols) + "b\n";
        for (int i = 0; i < b2protocolStrings.length; ++i) {
            if (!this.checkBit(this.b2protocols, i)) continue;
            string = string + "Bit[" + i + "] - " + b2protocolStrings[i] + "\n";
        }
        return string;
    }

    private String getB3ProtocolSupport() {
        String string = "B3 protocol support : 0" + Integer.toBinaryString(this.b3protocols) + "b\n";
        for (int i = 0; i < b3protocolStrings.length; ++i) {
            if (!this.checkBit(this.b3protocols, i)) continue;
            string = string + "Bit[" + i + "] - " + b3protocolStrings[i] + "\n";
        }
        return string;
    }

    public DefaultMutableTreeNode toTree() {
        int n;
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("capi profile");
        defaultMutableTreeNode.add(new DefaultMutableTreeNode("Number of B-Channels : " + this.noBChannels));
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("options : 0" + Integer.toBinaryString(this.options) + "b");
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        for (n = 0; n < optionStrings.length; ++n) {
            if (!this.checkBit(this.options, n)) continue;
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Bit[" + n + "] - " + optionStrings[n]));
        }
        defaultMutableTreeNode2 = new DefaultMutableTreeNode("B1 protocol support : 0" + Integer.toBinaryString(this.b1protocols) + "b");
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        for (n = 0; n < b1protocolStrings.length; ++n) {
            if (!this.checkBit(this.b1protocols, n)) continue;
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Bit[" + n + "] - " + b1protocolStrings[n]));
        }
        defaultMutableTreeNode2 = new DefaultMutableTreeNode("B2 protocol support : 0" + Integer.toBinaryString(this.b2protocols) + "b");
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        for (n = 0; n < b2protocolStrings.length; ++n) {
            if (!this.checkBit(this.b2protocols, n)) continue;
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Bit[" + n + "] - " + b2protocolStrings[n]));
        }
        defaultMutableTreeNode2 = new DefaultMutableTreeNode("B3 protocol support : 0" + Integer.toBinaryString(this.b3protocols) + "b");
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        for (n = 0; n < b3protocolStrings.length; ++n) {
            if (!this.checkBit(this.b3protocols, n)) continue;
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Bit[" + n + "] - " + b3protocolStrings[n]));
        }
        return defaultMutableTreeNode;
    }
}

