/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.capi;

import uk.co.mmscomputing.device.capi.CapiChannel;
import uk.co.mmscomputing.device.capi.CapiMetadata;
import uk.co.mmscomputing.device.capi.CapiPlugin;
import uk.co.mmscomputing.device.capi.protocol.SpeechProtocol;
import uk.co.mmscomputing.sms.SMSMetadata;
import uk.co.mmscomputing.sms.SMSPluginHandler;
import uk.co.mmscomputing.sms.SMSPluginReceiver;
import uk.co.mmscomputing.util.metadata.Metadata;

public class CapiSMSPlugin
implements CapiPlugin {
    private SMSPluginReceiver receiver;

    public CapiSMSPlugin(SMSPluginReceiver sMSPluginReceiver) {
        this.receiver = sMSPluginReceiver;
    }

    public void update(Object object, Metadata metadata) {
        CapiMetadata.Indication indication;
        if (object instanceof CapiMetadata.Indication && !(indication = (CapiMetadata.Indication)object).isAccepted()) {
            SMSMetadata sMSMetadata = new SMSMetadata();
            sMSMetadata.setState(1);
            sMSMetadata.setLocalNo(indication.localno);
            sMSMetadata.setRemoteNo(indication.remoteno);
            this.receiver.update(SMSMetadata.STATE, sMSMetadata);
            if (sMSMetadata.getAccept()) {
                indication.setPlugin(this);
                indication.setAccept(0);
                indication.setProtocol(new SpeechProtocol());
            }
        }
    }

    public void serve(CapiChannel capiChannel) {
        new SMSThread(capiChannel).start();
    }

    private class SMSThread
    extends Thread {
        CapiChannel channel;

        public SMSThread(CapiChannel capiChannel) {
            this.channel = capiChannel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                SMSMetadata sMSMetadata = new SMSMetadata();
                sMSMetadata.setState(2);
                CapiSMSPlugin.this.receiver.update(SMSMetadata.STATE, sMSMetadata);
                SMSPluginHandler sMSPluginHandler = sMSMetadata.getHandler();
                sMSPluginHandler.run(this.channel.getLocalNo(), this.channel.getRemoteNo(), this.channel.getPCMInputStream(), this.channel.getPCMOutputStream());
                sMSMetadata.setState(0);
                CapiSMSPlugin.this.receiver.update(SMSMetadata.STATE, sMSMetadata);
            }
            catch (Exception exception) {
                System.out.println("9\b" + this.getClass().getName() + ".run\n\tDisconnected call.\n\t" + exception);
                exception.printStackTrace();
            }
            finally {
                try {
                    this.channel.close();
                }
                catch (Exception exception) {
                    System.err.println(this.getClass().getName() + ".run:\n\t" + exception);
                    System.out.println("3\b" + this.getClass().getName() + ".run:\n\t" + exception);
                }
            }
        }
    }
}

