/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.capi;

import uk.co.mmscomputing.device.capi.CapiCallApplication;
import uk.co.mmscomputing.device.capi.CapiChannel;
import uk.co.mmscomputing.device.capi.CapiEnumerator;
import uk.co.mmscomputing.device.capi.CapiInfoPlugin;
import uk.co.mmscomputing.device.capi.CapiMetadata;
import uk.co.mmscomputing.device.capi.CapiPanel;
import uk.co.mmscomputing.device.capi.CapiPlugin;
import uk.co.mmscomputing.device.capi.CapiServerApplication;
import uk.co.mmscomputing.device.capi.exception.CapiException;
import uk.co.mmscomputing.device.capi.exception.CapiInformation;

public class CapiSystem
extends Thread {
    private CapiMetadata md = new CapiMetadata();
    private CapiServerApplication server = null;
    private static CapiSystem system = null;

    private CapiSystem() throws CapiException {
        this.md.useMaxLogicalConnections(CapiEnumerator.getNoOfBChannels());
        this.md.useALaw();
        this.md.use64kBit();
        this.md.acceptAllCalls();
        this.md.setController(1);
        this.server = new CapiServerApplication(this.md);
        this.server.start();
    }

    public int getController() {
        return this.md.getController();
    }

    public void setController(int n) {
        this.md.setController(n);
    }

    public CapiCallApplication getCaller() {
        return this.server;
    }

    public CapiServerApplication getServer() {
        return this.server;
    }

    public CapiPanel getGUI() throws CapiInformation {
        return new CapiPanel(this.md);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            while (this.server.isRunning()) {
                CapiChannel capiChannel = this.server.accept();
                if (!this.server.isRunning()) {
                    break;
                }
                capiChannel.getPlugin().serve(capiChannel);
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.server = null;
        }
    }

    public void close() {
        if (this.server != null) {
            this.server.close();
        }
    }

    public void addPlugin(CapiPlugin capiPlugin) {
        this.md.addListener(0, capiPlugin);
    }

    public void addPlugin(int n, CapiPlugin capiPlugin) {
        this.md.addListener(n, capiPlugin);
        this.printPlugins();
    }

    public void removePlugin(CapiPlugin capiPlugin) {
        this.md.removeListener(capiPlugin);
    }

    public void printPlugins() {
        System.err.println(this.md);
    }

    public static synchronized CapiSystem getSystem() throws CapiException {
        if (system != null) {
            return system;
        }
        system = new CapiSystem();
        system.start();
        system.addPlugin(new CapiInfoPlugin());
        return system;
    }
}

