/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.capi;

import uk.co.mmscomputing.device.capi.CapiConfMsg;
import uk.co.mmscomputing.device.capi.CapiConstants;
import uk.co.mmscomputing.device.capi.Rider;
import uk.co.mmscomputing.device.capi.ctrl.ListenConf;
import uk.co.mmscomputing.device.capi.facility.FacilityConf;
import uk.co.mmscomputing.device.capi.facility.FacilityInd;
import uk.co.mmscomputing.device.capi.man.ManufacturerConf;
import uk.co.mmscomputing.device.capi.man.ManufacturerInd;
import uk.co.mmscomputing.device.capi.ncc.ConnectB3ActiveInd;
import uk.co.mmscomputing.device.capi.ncc.ConnectB3Conf;
import uk.co.mmscomputing.device.capi.ncc.ConnectB3Ind;
import uk.co.mmscomputing.device.capi.ncc.ConnectB3T90ActiveInd;
import uk.co.mmscomputing.device.capi.ncc.DataB3Conf;
import uk.co.mmscomputing.device.capi.ncc.DataB3Ind;
import uk.co.mmscomputing.device.capi.ncc.DisconnectB3Conf;
import uk.co.mmscomputing.device.capi.ncc.DisconnectB3Ind;
import uk.co.mmscomputing.device.capi.ncc.ResetB3Conf;
import uk.co.mmscomputing.device.capi.ncc.ResetB3Ind;
import uk.co.mmscomputing.device.capi.plc.AlertConf;
import uk.co.mmscomputing.device.capi.plc.ConnectActiveInd;
import uk.co.mmscomputing.device.capi.plc.ConnectConf;
import uk.co.mmscomputing.device.capi.plc.ConnectInd;
import uk.co.mmscomputing.device.capi.plc.DisconnectConf;
import uk.co.mmscomputing.device.capi.plc.DisconnectInd;
import uk.co.mmscomputing.device.capi.plc.InfoConf;
import uk.co.mmscomputing.device.capi.plc.InfoInd;
import uk.co.mmscomputing.device.capi.plc.SelectBProtocolConf;

public class MsgIn
implements CapiConstants {
    public int len;
    public int appid;
    public int cmd;
    public int scmd;
    public int msgno;
    public int lineid;
    static String[] hexs = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};

    public MsgIn(Rider rider) {
        rider.reset();
        this.len = rider.readWord();
        this.appid = rider.readWord();
        this.cmd = rider.read();
        this.scmd = rider.read();
        this.msgno = rider.readWord();
        this.lineid = rider.readDWord();
    }

    public String toString() {
        String string = this.getClass().getName() + "\n";
        string = string + "length = " + this.len + "\n";
        string = string + "appid  = " + this.appid + "\n";
        string = string + "cmd    = 0x" + Integer.toHexString(this.cmd) + "\n";
        string = string + "scmd   = 0x" + Integer.toHexString(this.scmd) + "\n";
        string = string + "msgno  = " + this.msgno + "\n";
        string = string + "lineid = 0x" + Integer.toHexString(this.lineid) + "\n";
        return string;
    }

    public static String toString(byte[] byArray) {
        int n;
        String string = "\n";
        for (n = 0; n < byArray.length; ++n) {
            string = string + " ";
            string = string + hexs[byArray[n] >> 4 & 0xF];
            string = string + hexs[byArray[n] & 0xF];
            if ((n + 1) % 8 != 0) continue;
            string = string + "\n";
        }
        if ((n + 1) % 8 != 0) {
            string = string + "\n";
        }
        return string;
    }

    public static MsgIn createConf(Rider rider, int n) {
        switch (n) {
            case 2: {
                return new ConnectConf(rider);
            }
            case 130: {
                return new ConnectB3Conf(rider);
            }
            case 132: {
                return new DisconnectB3Conf(rider);
            }
            case 4: {
                return new DisconnectConf(rider);
            }
            case 134: {
                return new DataB3Conf(rider);
            }
            case 5: {
                return new ListenConf(rider);
            }
            case 1: {
                return new AlertConf(rider);
            }
            case 8: {
                return new InfoConf(rider);
            }
            case 128: {
                return FacilityConf.create(rider);
            }
            case 135: {
                return new ResetB3Conf(rider);
            }
            case 65: {
                return new SelectBProtocolConf(rider);
            }
            case 255: {
                return ManufacturerConf.create(rider);
            }
        }
        System.out.println("3\bMsgIn.createConf:\n\tUnknown CONF command in CAPI confirmation [" + Integer.toHexString(n) + "]");
        return new CapiConfMsg(rider);
    }

    public static MsgIn createInd(Rider rider, int n) {
        switch (n) {
            case 3: {
                return new ConnectActiveInd(rider);
            }
            case 131: {
                return new ConnectB3ActiveInd(rider);
            }
            case 136: {
                return new ConnectB3T90ActiveInd(rider);
            }
            case 4: {
                return new DisconnectInd(rider);
            }
            case 132: {
                return new DisconnectB3Ind(rider);
            }
            case 2: {
                return new ConnectInd(rider);
            }
            case 134: {
                return new DataB3Ind(rider);
            }
            case 130: {
                return new ConnectB3Ind(rider);
            }
            case 8: {
                return new InfoInd(rider);
            }
            case 128: {
                return FacilityInd.create(rider);
            }
            case 135: {
                return new ResetB3Ind(rider);
            }
            case 255: {
                return ManufacturerInd.create(rider);
            }
        }
        System.out.println("bMsgIn.createInd:\n\tUnknown IND command in CAPI indication [" + Integer.toHexString(n) + "]");
        throw new IllegalArgumentException();
    }

    public static MsgIn create(Rider rider) {
        rider.skip(4);
        int n = rider.read();
        int n2 = rider.read();
        rider.skip(6);
        try {
            switch (n2) {
                case 129: {
                    return MsgIn.createConf(rider, n);
                }
                case 130: {
                    return MsgIn.createInd(rider, n);
                }
            }
            System.out.println("3\bMsgIn.create : Unknown sub command [" + Integer.toHexString(n2) + "]");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            indexOutOfBoundsException.printStackTrace();
        }
        return new MsgIn(rider);
    }

    public static MsgIn create(byte[] byArray) {
        return MsgIn.create(new Rider(byArray, 0, byArray[0] & 0xFF | (byArray[0] & 0xFF) << 8));
    }
}

