/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.capi;

import uk.co.mmscomputing.device.capi.CapiConstants;
import uk.co.mmscomputing.device.capi.StructOut;

public class MsgOut
extends StructOut
implements CapiConstants {
    private static final int hdlen = 12;
    private static int msgnumber = 1;
    public int appid;
    public int cmd;
    public int scmd;
    public int msgno;
    public int lineid;

    public MsgOut(int n) {
        super(12 + n);
    }

    public MsgOut(int n, int n2, int n3, int n4, int n5) {
        super(12 + n);
        this.encode(n, n2, n3, n4, n5);
    }

    public void encode(int n, int n2, int n3, int n4, int n5) {
        this.setIndex(0);
        this.writeWord(12 + n);
        this.appid = n2;
        this.cmd = n3;
        this.scmd = n4;
        this.msgno = msgnumber++ & 0xFFFF;
        this.lineid = n5;
        this.writeWord(n2);
        this.writeByte(n3);
        this.writeByte(n4);
        this.writeWord(this.msgno);
        this.writeDWord(n5);
    }

    public String toString() {
        String string = this.getClass().getName() + "\n";
        string = string + "length = " + this.getIndex() + "\n";
        string = string + "appid  = " + this.appid + "\n";
        string = string + "cmd    = 0x" + Integer.toHexString(this.cmd) + "\n";
        string = string + "scmd   = 0x" + Integer.toHexString(this.scmd) + "\n";
        string = string + "msgno  = " + this.msgno + "\n";
        string = string + "lineid = 0x" + Integer.toHexString(this.lineid) + "\n";
        return string;
    }
}

