/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.capi;

public class Rider {
    private int[] stack = new int[32];
    private byte[] data;
    private int off;
    private int sp;
    private int index;
    static String[] hexs = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};

    public Rider() {
        this.data = new byte[0];
        this.off = 0;
        this.sp = 0;
        this.stack[this.sp] = 0;
        this.index = 0;
    }

    public void set(byte[] byArray, int n, int n2) {
        this.data = byArray;
        this.off = n;
        this.sp = 0;
        this.stack[this.sp] = n2;
        this.index = 0;
    }

    public void set(byte[] byArray) {
        this.set(byArray, 0, byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8);
    }

    public Rider(byte[] byArray) {
        this.set(byArray, 0, byArray.length);
    }

    public Rider(byte[] byArray, int n, int n2) {
        this.set(byArray, n, n2);
    }

    public void setLength() {
        int n = this.read();
        this.stack[++this.sp] = n + this.index;
    }

    public void skip(int n) {
        if (this.stack[this.sp] <= this.index + n) {
            throw new IndexOutOfBoundsException("" + (this.index + n));
        }
        this.index += n;
    }

    public void skip() {
        this.index = this.stack[this.sp--];
    }

    public int available() {
        return this.stack[this.sp] - this.index;
    }

    public void reset() {
        this.sp = 0;
        this.index = 0;
    }

    public void structBegin() {
        int n = this.read();
        if (n == 255) {
            n = this.readWord();
        }
        this.stack[++this.sp] = n + this.index;
    }

    public void structEnd() {
        this.index = this.stack[this.sp--];
    }

    public int read() {
        if (this.index < this.stack[this.sp]) {
            int n = this.data[this.off + this.index] & 0xFF;
            ++this.index;
            return n;
        }
        throw new IndexOutOfBoundsException();
    }

    public int readWord() {
        return this.read() | this.read() << 8;
    }

    public int readDWord() {
        return this.read() | this.read() << 8 | this.read() << 16 | this.read() << 24;
    }

    public long readQWord() {
        return this.read() | this.read() << 8 | this.read() << 16 | this.read() << 24 | this.read() << 32 | this.read() << 40 | this.read() << 48 | this.read() << 56;
    }

    public String readString() {
        String string = new String(this.data, this.off + this.index, this.stack[this.sp] - this.index);
        this.index = this.stack[this.sp];
        return string;
    }

    public byte[] getBytes() {
        byte[] byArray = new byte[this.stack[this.sp] - this.index];
        System.arraycopy(this.data, this.off + this.index, byArray, 0, byArray.length);
        return byArray;
    }

    public byte[] readStruct() {
        this.structBegin();
        byte[] byArray = this.getBytes();
        this.structEnd();
        return byArray;
    }

    public String toString() {
        int n;
        String string = "Rider data - \n index = " + this.index + " sp = " + this.stack[this.sp] + "\n";
        for (n = this.index; n < this.stack[this.sp]; ++n) {
            string = string + " ";
            string = string + hexs[this.data[n] >> 4 & 0xF];
            string = string + hexs[this.data[n] & 0xF];
            if ((n + 1) % 8 != 0) continue;
            string = string + "\n";
        }
        if ((n + 1) % 8 != 0) {
            string = string + "\n";
        }
        return string;
    }
}

