/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.capi.facility;

import uk.co.mmscomputing.device.capi.MsgIn;
import uk.co.mmscomputing.device.capi.Rider;
import uk.co.mmscomputing.device.capi.facility.FacilityConf;

public class EchoCancellerConf
extends FacilityConf {
    protected int function;

    public EchoCancellerConf(Rider rider) {
        super(rider);
        this.function = rider.readWord();
        rider.structBegin();
    }

    public static MsgIn create(Rider rider) {
        int n = rider.readWord();
        rider.structBegin();
        switch (n) {
            case 0: {
                return new GetSupportedServicesConf(rider);
            }
            case 1: {
                return new EnableConf(rider);
            }
            case 2: {
                return new DisableConf(rider);
            }
        }
        return new EchoCancellerConf(rider);
    }

    public int getFunctionNo() {
        return this.function;
    }

    public String toString() {
        String string = super.toString();
        string = string + "function : " + this.function + "\n\t";
        return string;
    }

    public static class DisableConf
    extends EchoCancellerConf {
        public DisableConf(Rider rider) {
            super(rider);
            if (this.info == 0) {
                this.info = rider.readWord();
            }
        }
    }

    public static class EnableConf
    extends EchoCancellerConf {
        public EnableConf(Rider rider) {
            super(rider);
            if (this.info == 0) {
                this.info = rider.readWord();
            }
        }
    }

    public static class GetSupportedServicesConf
    extends EchoCancellerConf {
        private int options;
        private int maxTailLength;
        private int maxPreDelay;

        public GetSupportedServicesConf(Rider rider) {
            super(rider);
            if (this.info == 0) {
                this.info = rider.readWord();
                if (this.info == 0) {
                    this.options = rider.readWord();
                    this.maxTailLength = rider.readWord();
                    this.maxPreDelay = rider.readWord();
                }
            }
        }

        public int getOptions() {
            return this.options;
        }

        public int getMaxTailLength() {
            return this.maxTailLength;
        }

        public int getMaxPreDelay() {
            return this.maxPreDelay;
        }

        public String toString() {
            String string = super.toString();
            string = string + "options          : 0" + Integer.toBinaryString(this.options) + "b\n\t";
            string = string + "maxTailLength    : " + this.maxTailLength + "\n\t";
            string = string + "maxPreDelay      : " + this.maxPreDelay + "\n\t";
            return string;
        }
    }
}

