/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.capi.facility;

import uk.co.mmscomputing.device.capi.Rider;
import uk.co.mmscomputing.device.capi.facility.FacilityInd;

public class InterconnectInd
extends FacilityInd {
    public static final int ConnectActive = 1;
    public static final int Disconnect = 2;
    protected int function;
    protected int participant;
    protected int serviceReason;

    public InterconnectInd(Rider rider) {
        super(rider);
        this.function = rider.readWord();
        rider.structBegin();
        this.participant = rider.readDWord();
        this.serviceReason = this.function == 2 ? rider.readWord() : -1;
    }

    public String toString() {
        String string = super.toString();
        string = string + "function : " + (this.function == 1 ? "ConnectActive" : "Disconnect") + "\n\t";
        string = string + "participant : 0x" + Integer.toHexString(this.participant) + "\n\t";
        if (this.serviceReason != -1) {
            switch (this.serviceReason) {
                case 0: {
                    string = string + "User Initiated\n\t";
                    break;
                }
                case 14336: {
                    string = string + "PLCI has no B-Channel\n\t";
                    break;
                }
                case 14337: {
                    string = string + "Lines not compatible\n\t";
                    break;
                }
                case 14338: {
                    string = string + "PLCI(s) is(are) not in any or not in the same interconnection.\n\t";
                    break;
                }
                default: {
                    string = string + "Unknown service reason\n\t";
                }
            }
        }
        return string;
    }
}

