/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.capi.facility;

import uk.co.mmscomputing.device.capi.StructOut;
import uk.co.mmscomputing.device.capi.facility.FacilityReq;

public class SupServiceReq
extends FacilityReq {
    public SupServiceReq(int n, int n2, int n3, StructOut structOut) {
        super(n, n2, 3, SupServiceReq.getFacReqParam(n3, structOut));
    }

    private static StructOut getFacReqParam(int n, StructOut structOut) {
        StructOut structOut2 = new StructOut(2 + structOut.getLength());
        structOut2.writeWord(n);
        structOut2.writeStruct(structOut);
        return structOut2;
    }

    public static SupServiceReq getSuspendReq(int n, int n2, byte[] byArray) {
        StructOut structOut = new StructOut(byArray.length);
        structOut.writeData(byArray, 0, byArray.length);
        return new SupServiceReq(n, n2, 4, structOut);
    }

    public static SupServiceReq getResumeReq(int n, int n2, byte[] byArray) {
        StructOut structOut = new StructOut(byArray.length);
        structOut.writeData(byArray, 0, byArray.length);
        return new SupServiceReq(n, n2, 5, structOut);
    }

    public static SupServiceReq get3PTYBeginReq(int n, int n2) {
        StructOut structOut = new StructOut(4);
        structOut.writeDWord(n2);
        return new SupServiceReq(n, n2, 7, structOut);
    }

    public static SupServiceReq get3PTYEndReq(int n, int n2) {
        StructOut structOut = new StructOut(4);
        structOut.writeDWord(n2);
        return new SupServiceReq(n, n2, 8, structOut);
    }

    public static class ECTReq
    extends SupServiceReq {
        private static StructOut getHeldPLCIParam(int n) {
            StructOut structOut = new StructOut(4);
            structOut.writeDWord(n);
            return structOut;
        }

        public ECTReq(int n, int n2) {
            super(n, n2, 6, ECTReq.getHeldPLCIParam(n2));
        }

        public ECTReq(int n, int n2, int n3) {
            super(n, n2, 6, ECTReq.getHeldPLCIParam(n3));
        }
    }

    public static class RetrieveReq
    extends SupServiceReq {
        public RetrieveReq(int n, int n2) {
            super(n, n2, 3, StructOut.empty);
        }
    }

    public static class HoldReq
    extends SupServiceReq {
        public HoldReq(int n, int n2) {
            super(n, n2, 2, StructOut.empty);
        }
    }

    public static class ListenReq
    extends SupServiceReq {
        public static final String[] notificationStrings = new String[]{"Hold / Retrieve Notifications", "Terminal portability Notifications", "ECT Notifications", "3PTY Notifications", "Call Forwarding/Deflection Notifications/Information", "reserved (no Notifications for Call-Deflection)", "reserved (no Notifications for MCID)", "CCBS Notifications/Information", "MWI Indication", "CCNR Notification", "CONF Notifications/Information"};

        public ListenReq(int n, int n2) {
            this(n, n2, 863);
        }

        public ListenReq(int n, int n2, int n3) {
            super(n, n2, 1, ListenReq.getFacReqParam(n3));
        }

        private static StructOut getFacReqParam(int n) {
            StructOut structOut = new StructOut(4);
            structOut.writeDWord(n);
            return structOut;
        }
    }

    public static class GetSupportedServicesReq
    extends SupServiceReq {
        public GetSupportedServicesReq(int n, int n2) {
            super(n, n2, 0, StructOut.empty);
        }
    }
}

