/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.capi.facility;

import uk.co.mmscomputing.device.capi.Rider;
import uk.co.mmscomputing.device.capi.facility.FacilityConf;

public class V42InfoConf
extends FacilityConf {
    private int mode;
    private int noOfCodeWords;
    private int maxStringSize;
    private int txTotal;
    private int txCompressed;
    private int rxTotal;
    private int rxDecompressed;

    public V42InfoConf(Rider rider) {
        super(rider);
        if (this.info != 0) {
            return;
        }
        try {
            this.info = rider.readWord();
            if (this.info == 0) {
                this.mode = rider.readWord();
                if (this.mode == 1) {
                    this.noOfCodeWords = rider.readWord();
                    this.maxStringSize = rider.readWord();
                    this.txTotal = rider.readDWord();
                    this.txCompressed = rider.readDWord();
                    this.rxTotal = rider.readDWord();
                    this.rxDecompressed = rider.readDWord();
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            indexOutOfBoundsException.printStackTrace();
        }
    }

    public int getInfo() {
        return this.info;
    }

    public String getInformation() {
        if (this.info != 0) {
            return "No Information about V42 bis compression available.";
        }
        String string = "";
        if (this.mode == 0) {
            string = string + "No compression\n";
        } else if (this.mode == 1) {
            string = string + "V.42 bis compression mode\n";
            string = string + "Number of code words                           :" + this.noOfCodeWords + "\n";
            string = string + "Max String Length                              :" + this.maxStringSize + "\n";
            string = string + "Number of octets transmitted                   :" + this.txTotal + "\n";
            string = string + "Number of octets transmitted after compression :" + this.txCompressed + "\n";
            string = string + "Number of octets received                      :" + this.rxTotal + "\n";
            string = string + "Number of octets received after decompression  :" + this.rxDecompressed + "\n";
        }
        return string;
    }

    public String toString() {
        String string = super.toString();
        string = string + "info : " + this.getInformation() + "\n\t";
        return string;
    }
}

