/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.capi.man;

import uk.co.mmscomputing.device.capi.CapiConfMsg;
import uk.co.mmscomputing.device.capi.MsgIn;
import uk.co.mmscomputing.device.capi.Rider;
import uk.co.mmscomputing.device.capi.man.ManufacturerConstants;
import uk.co.mmscomputing.device.capi.man.avm.AVMConf;
import uk.co.mmscomputing.device.capi.man.eicon.EiconConf;

public class ManufacturerConf
extends CapiConfMsg
implements ManufacturerConstants {
    private int manuid;

    public ManufacturerConf(Rider rider) {
        super(rider);
        this.manuid = rider.readDWord();
    }

    public int getManufacturerId() {
        return this.manuid;
    }

    public String toString() {
        String string = super.toString();
        string = string + "manu  id : 0x" + Integer.toHexString(this.manuid) + " " + (char)(this.manuid & 0xFF) + (char)(this.manuid >> 8 & 0xFF) + (char)(this.manuid >> 16 & 0xFF) + (char)(this.manuid >> 24 & 0xFF) + "\n";
        return string;
    }

    public static MsgIn create(Rider rider) {
        int n = rider.readDWord();
        switch (n) {
            case 558716481: {
                return AVMConf.create(rider);
            }
            case 0x44444944: {
                return EiconConf.create(rider);
            }
        }
        System.err.println("uk.co.mmscomputing.device.capi.man.create:\n\tUnknown ManufacturerConf Message.\n\t" + Integer.toHexString(n));
        return new ManufacturerConf(rider);
    }
}

