/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.capi.man.avm;

import javax.swing.tree.DefaultMutableTreeNode;
import uk.co.mmscomputing.device.capi.CapiProfile;
import uk.co.mmscomputing.device.capi.man.avm.AVMConstants;

public class AVMProfile
extends CapiProfile
implements AVMConstants {
    private int dProtocol = 0;
    private int line = 0;

    public AVMProfile(byte[] byArray) {
        super(byArray);
        if (byArray[44] == 1) {
            this.dProtocol = byArray[47] & 0xFF | (byArray[48] & 0xFF) << 8;
            this.line = byArray[49] & 0xFF;
        }
    }

    public String toString() {
        int n;
        String string = super.toString();
        string = string + "\nAVM specific data:\n";
        string = string + "D channel protocol : 0" + Integer.toBinaryString(this.dProtocol) + "b\n";
        for (n = 0; n < dProtocolStrings.length; ++n) {
            if (!this.checkBit(this.dProtocol, n)) continue;
            string = string + "Bit[" + n + "] - " + dProtocolStrings[n] + "\n";
        }
        string = string + "Type of line : 0" + Integer.toBinaryString(this.line) + "b\n";
        for (n = 0; n < lineStrings.length; ++n) {
            if (!this.checkBit(this.line, n)) continue;
            string = string + "Bit[" + n + "] - " + lineStrings[n] + "\n";
        }
        return string;
    }

    public DefaultMutableTreeNode toTree() {
        int n;
        DefaultMutableTreeNode defaultMutableTreeNode = super.toTree();
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("D channel protocol : 0" + Integer.toBinaryString(this.dProtocol) + "b");
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        for (n = 0; n < dProtocolStrings.length; ++n) {
            if (!this.checkBit(this.dProtocol, n)) continue;
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Bit[" + n + "] - " + dProtocolStrings[n]));
        }
        defaultMutableTreeNode2 = new DefaultMutableTreeNode("Type of line : 0" + Integer.toBinaryString(this.line) + "b");
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        for (n = 0; n < lineStrings.length; ++n) {
            if (!this.checkBit(this.line, n)) continue;
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Bit[" + n + "] - " + lineStrings[n]));
        }
        return defaultMutableTreeNode;
    }
}

