/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.capi.ncc;

import uk.co.mmscomputing.device.capi.CapiIndMsg;
import uk.co.mmscomputing.device.capi.Rider;
import uk.co.mmscomputing.device.capi.jcapi;

public class DataB3Ind
extends CapiIndMsg {
    private int nptr;
    private int handle;
    private int nlen;
    private int flags;
    private long n64ptr;

    public DataB3Ind(Rider rider) {
        super(rider);
        this.nptr = rider.readDWord();
        this.nlen = rider.readWord();
        this.handle = rider.readWord();
        this.flags = rider.readWord();
        if (this.nptr == 0) {
            this.n64ptr = rider.readQWord();
        }
    }

    public int getHandle() {
        return this.handle;
    }

    public int getPayloadPtr() {
        return this.nptr;
    }

    public int getPayloadLength() {
        return this.nlen;
    }

    public byte[] getPayload(byte[] byArray) {
        if (this.nptr != 0) {
            return jcapi.copyFromNative32bitDataPtr(byArray, this.nptr, this.nlen);
        }
        return jcapi.copyFromNative64bitDataPtr(byArray, this.n64ptr, this.nlen);
    }

    public String toString() {
        String string = super.toString();
        string = this.nptr != 0 ? string + "nptr     = 0x" + Integer.toHexString(this.nptr) + "\n" : string + "n64ptr   = 0x" + Long.toHexString(this.n64ptr) + "\n";
        string = string + "nlen     = " + this.nlen + "\n";
        string = string + "handle   = " + this.handle + "\n";
        string = string + "flags    = 0" + Integer.toBinaryString(this.flags) + "b\n";
        return string;
    }
}

