/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.capi.parameter;

import uk.co.mmscomputing.device.capi.CapiConstants;
import uk.co.mmscomputing.device.capi.MsgIn;
import uk.co.mmscomputing.device.capi.Rider;

public class NCPI
implements CapiConstants {
    public int protocol;

    public static NCPI create(int n, Rider rider) {
        switch (n) {
            case 0: {
                return new Transparent();
            }
            case 1: {
                return new T90NL();
            }
            case 2: {
                return new ISO8082(rider);
            }
            case 3: {
                return new X25(rider);
            }
            case 4: {
                return new T30Fax(rider);
            }
            case 5: {
                return new T30FaxExt(rider);
            }
            case 7: {
                return new Modem(rider);
            }
        }
        return new NCPI();
    }

    public static class Modem
    extends NCPI {
        public int rate;
        public int protocol;

        public Modem(Rider rider) {
            try {
                this.rate = rider.readWord();
                this.protocol = rider.readWord();
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                indexOutOfBoundsException.printStackTrace();
            }
        }

        public String getProtocolDesc() {
            String string = "";
            string = string + "protocol   = 0x" + Integer.toHexString(this.protocol) + "\n\t";
            if ((this.protocol & 1) != 0) {
                string = string + "V.42/V.42 bis successfully negotiated.\n\t";
            }
            if ((this.protocol & 2) != 0) {
                string = string + "MNP4/MNP5 successfully negotiated.\n\t";
            }
            if ((this.protocol & 4) != 0) {
                string = string + "Transparent mode successfully negotiated.\n\t";
            }
            if ((this.protocol & 0x10) != 0) {
                string = string + "Compression successfully negotiated.\n\t";
            }
            return string;
        }

        public String toString() {
            String string = super.toString();
            string = string + "rate   = " + this.rate + "\n\t";
            string = string + this.getProtocolDesc();
            return string;
        }
    }

    public static class T30FaxExt
    extends NCPI {
        public int bitrate;
        public int options;
        public int format;
        public int noofpages;
        public String remoteno;

        public T30FaxExt(Rider rider) {
            try {
                this.bitrate = rider.readWord();
                this.options = rider.readWord();
                this.format = rider.readWord();
                this.noofpages = rider.readWord();
                this.remoteno = rider.readString();
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                indexOutOfBoundsException.printStackTrace();
            }
        }

        public String getOptionsDesc() {
            String string = "";
            string = string + "options   = 0x" + Integer.toHexString(this.options) + "\n\t";
            if ((this.options & 1) != 0) {
                string = string + "Enable high resolution.\n\t";
            }
            if ((this.options & 2) != 0) {
                string = string + "Fax-polling request / indication.\n\t";
            }
            if ((this.options & 4) != 0) {
                string = string + "Req/Ind to send/poll another document after current document.\n\t";
            }
            if ((this.options & 0x400) != 0) {
                string = string + "JPEG colour images.\n\t";
            }
            if ((this.options & 0x800) != 0) {
                string = string + "JBIG grayscale/colour images.\n\t";
            }
            if ((this.options & 0x1000) != 0) {
                string = string + "JBIG progressive bi-level images.\n\t";
            }
            if ((this.options & 0x2000) != 0) {
                string = string + "MR compressed images.\n\t";
            }
            if ((this.options & 0x4000) != 0) {
                string = string + "MMR compressed images.\n\t";
            }
            if ((this.options & 0x8000) != 0) {
                string = string + "Not an ECM (Error Correction Mode) connection.\n\t";
            }
            return string;
        }

        public String toString() {
            String string = super.toString();
            string = string + "bitrate     = " + this.bitrate + "\n\t";
            string = string + this.getOptionsDesc();
            switch (this.format) {
                case 0: {
                    string = string + "format      = SFF\n\t";
                    break;
                }
                case 1: {
                    string = string + "format      = Plain\n\t";
                    break;
                }
                case 2: {
                    string = string + "format      = PCX\n\t";
                    break;
                }
                case 3: {
                    string = string + "format      = DCX\n\t";
                    break;
                }
                case 4: {
                    string = string + "format      = TIFF\n\t";
                    break;
                }
                case 5: {
                    string = string + "format      = ASCII\n\t";
                    break;
                }
                case 6: {
                    string = string + "format      = Extended Ansi\n\t";
                    break;
                }
                case 7: {
                    string = string + "format      = Binary file transfer\n\t";
                    break;
                }
                default: {
                    string = string + "format      = " + this.format + "\n\t";
                }
            }
            string = string + "noofpages   = " + this.noofpages + "\n\t";
            string = string + "remoteno    = \"" + this.remoteno + "\"\n\t";
            return string;
        }
    }

    public static class T30Fax
    extends NCPI {
        public int bitrate;
        public int resolution;
        public int format;
        public int noofpages;
        public String remoteno;

        public T30Fax(Rider rider) {
            try {
                this.bitrate = rider.readWord();
                this.resolution = rider.readWord();
                this.format = rider.readWord();
                this.noofpages = rider.readWord();
                this.remoteno = rider.readString();
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                indexOutOfBoundsException.printStackTrace();
            }
        }

        public String toString() {
            String string = super.toString();
            string = string + "bitrate     = " + this.bitrate + "\n\t";
            switch (this.resolution) {
                case 0: {
                    string = string + "resolution  = Standard\n\t";
                    break;
                }
                case 1: {
                    string = string + "resolution  = High\n\t";
                    break;
                }
                default: {
                    string = string + "resolution  = " + this.resolution + "\n\t";
                }
            }
            switch (this.format) {
                case 0: {
                    string = string + "format      = SFF\n\t";
                    break;
                }
                case 1: {
                    string = string + "format      = Plain\n\t";
                    break;
                }
                case 2: {
                    string = string + "format      = PCX\n\t";
                    break;
                }
                case 3: {
                    string = string + "format      = DCX\n\t";
                    break;
                }
                case 4: {
                    string = string + "format      = TIFF\n\t";
                    break;
                }
                case 5: {
                    string = string + "format      = ASCII\n\t";
                    break;
                }
                case 6: {
                    string = string + "format      = Extended Ansi\n\t";
                    break;
                }
                case 7: {
                    string = string + "format      = Binary file transfer\n\t";
                    break;
                }
                default: {
                    string = string + "format      = " + this.format + "\n\t";
                }
            }
            string = string + "noofpages   = " + this.noofpages + "\n\t";
            string = string + "remoteno    = \"" + this.remoteno + "\"\n\t";
            return string;
        }
    }

    public static class X25
    extends NCPI {
        public int options;
        public int group;
        public int channel;
        public byte[] contents;

        public X25(Rider rider) {
            try {
                this.options = rider.read();
                this.group = rider.read();
                this.channel = rider.read();
                this.contents = new byte[rider.available()];
                for (int i = 0; i < this.contents.length; ++i) {
                    this.contents[i] = (byte)rider.read();
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                indexOutOfBoundsException.printStackTrace();
            }
        }

        public String toString() {
            String string = super.toString();
            string = string + "options   = 0x" + Integer.toHexString(this.options) + "\n\t";
            string = string + "group     = 0x" + Integer.toHexString(this.group) + "\n\t";
            string = string + "channel   = 0x" + Integer.toHexString(this.channel) + "\n\t";
            if (this.contents != null) {
                string = string + MsgIn.toString(this.contents);
            }
            return string;
        }
    }

    public static class ISO8082
    extends NCPI {
        public int flags;
        public int group;
        public int channel;
        public byte[] contents;

        public ISO8082(Rider rider) {
            try {
                this.flags = rider.read();
                this.group = rider.read();
                this.channel = rider.read();
                this.contents = new byte[rider.available()];
                for (int i = 0; i < this.contents.length; ++i) {
                    this.contents[i] = (byte)rider.read();
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                indexOutOfBoundsException.printStackTrace();
            }
        }

        public String toString() {
            String string = super.toString();
            string = string + "flags     = 0x" + Integer.toHexString(this.flags) + "\n\t";
            string = string + "group     = 0x" + Integer.toHexString(this.group) + "\n\t";
            string = string + "channel   = 0x" + Integer.toHexString(this.channel) + "\n\t";
            if (this.contents != null) {
                string = string + MsgIn.toString(this.contents);
            }
            return string;
        }
    }

    public static class T90NL
    extends NCPI {
    }

    public static class Transparent
    extends NCPI {
    }
}

