/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.capi.plc;

import uk.co.mmscomputing.device.capi.CapiIndMsg;
import uk.co.mmscomputing.device.capi.Rider;
import uk.co.mmscomputing.device.capi.parameter.AdditionalInfo;
import uk.co.mmscomputing.device.capi.q931.BearerCapability;
import uk.co.mmscomputing.device.capi.q931.CalledPartyNumber;
import uk.co.mmscomputing.device.capi.q931.CalledPartySubAddress;
import uk.co.mmscomputing.device.capi.q931.CallingPartyNumber;
import uk.co.mmscomputing.device.capi.q931.CallingPartySubAddress;
import uk.co.mmscomputing.device.capi.q931.HighLayerCompatibility;
import uk.co.mmscomputing.device.capi.q931.LowLayerCompatibility;

public class ConnectInd
extends CapiIndMsg {
    private int cip = 0;
    private String calledPartyNumber = null;
    private String callingPartyNumber = null;
    private BearerCapability bc = null;
    private LowLayerCompatibility llc = null;
    private HighLayerCompatibility hlc = null;
    private AdditionalInfo.In addinfo = null;

    public ConnectInd(Rider rider) {
        super(rider);
        try {
            this.cip = rider.readWord();
            this.calledPartyNumber = new CalledPartyNumber(rider).getNumber();
            this.callingPartyNumber = new CallingPartyNumber(rider).getNumber();
            this.calledPartyNumber = this.calledPartyNumber + new CalledPartySubAddress(rider).getNumber();
            this.callingPartyNumber = this.callingPartyNumber + new CallingPartySubAddress(rider).getNumber();
            this.bc = new BearerCapability(rider);
            this.llc = new LowLayerCompatibility(rider);
            this.hlc = new HighLayerCompatibility(rider);
            this.addinfo = new AdditionalInfo.In(rider);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            indexOutOfBoundsException.printStackTrace();
        }
    }

    public int getCIP() {
        return this.cip;
    }

    public BearerCapability getBearerCapability() {
        return this.bc;
    }

    public String getLocalNo() {
        return this.calledPartyNumber;
    }

    public String getRemoteNo() {
        return this.callingPartyNumber;
    }

    public String toString() {
        String string = super.toString();
        string = string + "cip                = " + this.cip + "\n";
        string = string + "calledPartyNumber  = " + this.calledPartyNumber + "\n";
        string = string + "callingPartyNumber = " + this.callingPartyNumber + "\n";
        string = string + "bearer capability  = " + this.bc.toString() + "\n";
        string = string + "llc                = " + this.llc.toString() + "\n";
        string = string + "hlc                = " + this.hlc.toString() + "\n";
        string = string + "additional info    = " + this.addinfo.toString() + "\n";
        return string;
    }
}

