/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.capi.q931;

import uk.co.mmscomputing.device.capi.Rider;
import uk.co.mmscomputing.device.capi.q931.Q931;

public class BearerCapability
extends Q931 {
    public int codingStandard = -1;
    public int infoTransferCap = -1;
    public int transferMode = -1;
    public int infoTransferRate = -1;
    public int rateMultiplier = -1;
    public int userInfoLayer1Protocol = -1;
    public int userInfoLayer2Protocol = -1;
    public int userInfoLayer3Protocol = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BearerCapability(Rider rider) {
        rider.setLength();
        try {
            int n = rider.read();
            this.codingStandard = BearerCapability.getBits(n, 7, 6);
            if (this.codingStandard != 0) {
                throw new IllegalArgumentException();
            }
            this.infoTransferCap = BearerCapability.getBits(n, 5, 1);
            n = rider.read();
            this.transferMode = BearerCapability.getBits(n, 7, 6);
            this.infoTransferRate = BearerCapability.getBits(n, 5, 1);
            if (this.infoTransferRate == 24) {
                this.rateMultiplier = BearerCapability.getBits(rider.read(), 7, 1);
            }
            if (BearerCapability.getBits(n = rider.read(), 7, 6) != 1) {
                System.err.println(this.getClass().getName() + ":\n\tExpect Layer 1 Information.");
                return;
            }
            this.userInfoLayer1Protocol = BearerCapability.getBits(n, 5, 1);
            if (BearerCapability.isExt(n) && BearerCapability.isExt(n = rider.read()) && BearerCapability.isExt(n = rider.read()) && BearerCapability.isExt(n = rider.read())) {
                n = rider.read();
            }
            if (BearerCapability.getBits(n = rider.read(), 7, 6) != 2) {
                System.err.println(this.getClass().getName() + ":\n\tExpect Layer 2 Information.");
                return;
            }
            this.userInfoLayer2Protocol = BearerCapability.getBits(n, 5, 1);
            n = rider.read();
            if (BearerCapability.getBits(n, 7, 6) != 3) {
                System.err.println(this.getClass().getName() + ":\n\tExpect Layer 3 Information.");
                return;
            }
            this.userInfoLayer3Protocol = BearerCapability.getBits(n, 5, 1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        finally {
            rider.skip();
        }
    }

    public BearerCapability(byte[] byArray) {
        this(new Rider(byArray));
    }

    public int getSpeechCoding() {
        return this.userInfoLayer1Protocol;
    }

    public String toString() {
        String string = "Bearer Capability - ";
        string = string + "\n    Transfer Capability = " + InformationTransferCapabilityStrs[this.infoTransferCap];
        string = string + "\n    Transfer Rate = " + InformationTransferRateStrs[this.infoTransferRate];
        switch (this.userInfoLayer1Protocol) {
            case 2: {
                string = string + "\n    G.711 u-law";
                break;
            }
            case 3: {
                string = string + "\n    G.711 A-law";
            }
        }
        return string;
    }
}

