/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.capi.q931;

import uk.co.mmscomputing.device.capi.Rider;
import uk.co.mmscomputing.device.capi.StructOut;
import uk.co.mmscomputing.device.capi.q931.Q931;

public class CallingPartyNumber
extends Q931 {
    private int typeOfNumber = 0;
    private int numberingPlanIdentification = 0;
    private int presentationIndicator = 0;
    private int screeningIndicator = 0;
    private String digits = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CallingPartyNumber(Rider rider) {
        rider.setLength();
        try {
            int n = rider.read();
            this.typeOfNumber = CallingPartyNumber.getBits(n, 7, 5);
            this.numberingPlanIdentification = CallingPartyNumber.getBits(n, 4, 1);
            if (CallingPartyNumber.isExt(n)) {
                n = rider.read();
                this.presentationIndicator = CallingPartyNumber.getBits(n, 7, 6);
                this.screeningIndicator = CallingPartyNumber.getBits(n, 2, 1);
            }
            this.digits = rider.readString();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        finally {
            rider.skip();
        }
    }

    public CallingPartyNumber(byte[] byArray) {
        this(new Rider(byArray));
    }

    public String getNumber() {
        return this.digits;
    }

    public String toString() {
        String string = "Calling Party Number - \n";
        string = string + "Type Of Number = " + TypeOfNumberStrs[this.typeOfNumber] + "\n";
        string = string + "Numbering Plan = " + NumberingPlanStrs[this.numberingPlanIdentification] + "\n";
        string = string + "Digits         = " + this.digits + "\n";
        return string;
    }

    public static class Out
    extends StructOut {
        public Out(String string) {
            super(2 + string.length());
            this.writeByte(0);
            this.writeByte(128);
            this.writeData(string.getBytes(), 0, string.length());
        }
    }
}

