/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.capi.q931;

import uk.co.mmscomputing.device.capi.Rider;
import uk.co.mmscomputing.device.capi.q931.Q931;

public class Cause
extends Q931 {
    public int codingStandard = 0;
    public int location = 0;
    public int recommendation = 0;
    public int cause = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cause(Rider rider) {
        rider.setLength();
        try {
            int n = rider.read();
            this.codingStandard = Cause.getBits(n, 7, 6);
            if (this.codingStandard != 0) {
                throw new IllegalArgumentException();
            }
            this.location = Cause.getBits(n, 4, 1);
            if (Cause.isExt(n)) {
                this.recommendation = rider.read();
            }
            n = rider.read();
            this.cause = Cause.getBits(n, 7, 1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        finally {
            rider.skip();
        }
    }

    public Cause(byte[] byArray) {
        this(new Rider(byArray));
    }

    public String toString() {
        String string = "Cause - ";
        switch (this.location) {
            case 0: {
                string = string + "\n    Location: User";
                break;
            }
            case 1: {
                string = string + "\n    Location: Private network serving the local user";
                break;
            }
            case 2: {
                string = string + "\n    Location: Public network serving the local user";
                break;
            }
            case 3: {
                string = string + "\n    Location: Transit network";
                break;
            }
            case 4: {
                string = string + "\n    Location: Public network serving the remote user";
                break;
            }
            case 5: {
                string = string + "\n    Location: Private network serving the remote user";
                break;
            }
            case 6: {
                string = string + "\n    Location: Network beyond interworking point";
            }
        }
        switch (this.cause) {
            case 1: {
                string = string + "\n    unallocated (unassigned) number";
                break;
            }
            case 2: {
                string = string + "\n    no route to specifies transit network";
                break;
            }
            case 3: {
                string = string + "\n    no route to destination";
                break;
            }
            case 6: {
                string = string + "\n    channel unacceptable";
                break;
            }
            case 7: {
                string = string + "\n    call awarded and being delivered in an established channel";
                break;
            }
            case 16: {
                string = string + "\n    normal call clearing";
                break;
            }
            case 17: {
                string = string + "\n    user busy";
                break;
            }
            case 18: {
                string = string + "\n    no user responding";
                break;
            }
            case 19: {
                string = string + "\n    no answer from user (user alerted)";
                break;
            }
            case 22: {
                string = string + "\n    number changed";
                break;
            }
            case 26: {
                string = string + "\n    non-selected user clearing";
                break;
            }
            case 27: {
                string = string + "\n    destination out of order";
                break;
            }
            case 28: {
                string = string + "\n    invalid format (address incomplete)";
                break;
            }
            case 29: {
                string = string + "\n    facility rejected";
                break;
            }
            case 30: {
                string = string + "\n    response to status enquiry";
                break;
            }
            case 31: {
                string = string + "\n    normal, unspecified";
                break;
            }
            case 34: {
                string = string + "\n    no circuit/channel available";
                break;
            }
            case 38: {
                string = string + "\n    network out of order";
                break;
            }
            case 41: {
                string = string + "\n    temporary failure";
                break;
            }
            case 42: {
                string = string + "\n    switching equipment congestion";
                break;
            }
            case 43: {
                string = string + "\n    access information discarded";
                break;
            }
            case 44: {
                string = string + "\n    requested circuit/channel not available";
                break;
            }
            case 47: {
                string = string + "\n    resource unavailable, unspecified";
                break;
            }
            case 49: {
                string = string + "\n    quality of service not available";
                break;
            }
            case 50: {
                string = string + "\n    requested facility not subscribed";
                break;
            }
            case 57: {
                string = string + "\n    bearer capability not authorised";
                break;
            }
            case 58: {
                string = string + "\n    bearer capability not presently available";
                break;
            }
            case 63: {
                string = string + "\n    service or option not available unspecified";
                break;
            }
            case 65: {
                string = string + "\n    bearer capability not implemented";
                break;
            }
            case 66: {
                string = string + "\n    channel type not implemented";
                break;
            }
            case 69: {
                string = string + "\n    requested facility not implemented";
                break;
            }
            case 70: {
                string = string + "\n    only restricted digital information bearer capability is available";
                break;
            }
            case 79: {
                string = string + "\n    service or option not implemented, unspecified";
                break;
            }
            case 81: {
                string = string + "\n    invalid call reference value";
                break;
            }
            case 82: {
                string = string + "\n    identified channel does not exist";
                break;
            }
            case 83: {
                string = string + "\n    a suspended call exists, but this call identity does not";
                break;
            }
            case 84: {
                string = string + "\n    call identity in use";
                break;
            }
            case 85: {
                string = string + "\n    no call suspended";
                break;
            }
            case 86: {
                string = string + "\n    call having the requested call identity has been cleared";
                break;
            }
            case 88: {
                string = string + "\n    incompatible destination";
                break;
            }
            case 91: {
                string = string + "\n    invalid transit network selection";
                break;
            }
            case 95: {
                string = string + "\n    invalid message, unspecified";
                break;
            }
            case 96: {
                string = string + "\n    mandatory information element is missing";
                break;
            }
            case 97: {
                string = string + "\n    message type non-existent or not implemented";
                break;
            }
            case 98: {
                string = string + "\n    message not compatible with call state or messages TYPE NON-EXISTENT OR NOT IMPLEMENTED";
                break;
            }
            case 99: {
                string = string + "\n    information element non-existent or not implemented";
                break;
            }
            case 100: {
                string = string + "\n    invalid information element contents";
                break;
            }
            case 101: {
                string = string + "\n    message not compatible with call start";
                break;
            }
            case 102: {
                string = string + "\n    recovery on timer expiry";
                break;
            }
            case 111: {
                string = string + "\n    protocol error, unspecified";
                break;
            }
            case 127: {
                string = string + "\n    interworking, unspecified";
            }
        }
        return string;
    }
}

