/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.capi.q931;

import uk.co.mmscomputing.device.capi.Rider;
import uk.co.mmscomputing.device.capi.q931.Q931;

public class ChannelIdentification
extends Q931 {
    public int intId = 0;
    public int intType = 0;
    public int prefExcl = 0;
    public int dChannelInd = 0;
    public int channel = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelIdentification(Rider rider) {
        rider.setLength();
        try {
            int n = rider.read();
            this.intId = ChannelIdentification.getBits(n, 7, 7);
            this.intType = ChannelIdentification.getBits(n, 6, 6);
            this.prefExcl = ChannelIdentification.getBits(n, 4, 4);
            this.dChannelInd = ChannelIdentification.getBits(n, 3, 3);
            this.channel = ChannelIdentification.getBits(n, 2, 1);
            if (this.intId != 0) {
                while (ChannelIdentification.isExt(n = rider.read())) {
                }
                n = rider.read();
            }
            if (this.intType != 0) {
                // empty if block
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        finally {
            rider.skip();
        }
    }

    public ChannelIdentification(byte[] byArray) {
        this(new Rider(byArray));
    }

    public String toString() {
        String string = "Channel identification - \n";
        if (this.dChannelInd != 0) {
            string = string + " D-Channel\n";
        } else if (this.intType == 0) {
            switch (this.channel) {
                case 0: {
                    string = string + " BRI : No Channel\n";
                    break;
                }
                case 1: {
                    string = string + " BRI : B1 Channel\n";
                    break;
                }
                case 2: {
                    string = string + " BRI : B2 Channel\n";
                    break;
                }
                case 3: {
                    string = string + " BRI : B1/B2 Channel\n";
                }
            }
        } else {
            switch (this.channel) {
                case 0: {
                    string = string + " PRI : No Channel\n";
                    break;
                }
                case 1: {
                    string = string + " PRI : As indicated\n";
                    break;
                }
                case 2: {
                    string = string + " PRI : Reserved\n";
                    break;
                }
                case 3: {
                    string = string + " PRI : Any Channel\n";
                }
            }
        }
        return string;
    }
}

