/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.capi.q931;

import uk.co.mmscomputing.device.capi.Rider;
import uk.co.mmscomputing.device.capi.q931.BearerCapability;
import uk.co.mmscomputing.device.capi.q931.CalledPartyNumber;
import uk.co.mmscomputing.device.capi.q931.CalledPartySubAddress;
import uk.co.mmscomputing.device.capi.q931.CallingPartyNumber;
import uk.co.mmscomputing.device.capi.q931.CallingPartySubAddress;
import uk.co.mmscomputing.device.capi.q931.Cause;
import uk.co.mmscomputing.device.capi.q931.ChannelIdentification;
import uk.co.mmscomputing.device.capi.q931.Display;
import uk.co.mmscomputing.device.capi.q931.HighLayerCompatibility;
import uk.co.mmscomputing.device.capi.q931.KeypadFacility;
import uk.co.mmscomputing.device.capi.q931.LowLayerCompatibility;
import uk.co.mmscomputing.device.capi.q931.ProgressIndicator;
import uk.co.mmscomputing.device.capi.q931.Q931;
import uk.co.mmscomputing.device.capi.q931.Q931Constants;
import uk.co.mmscomputing.device.capi.q931.Q931Date;
import uk.co.mmscomputing.device.capi.q931.SendingComplete;
import uk.co.mmscomputing.device.capi.q931.UserUser;

public class Q931Factory
implements Q931Constants {
    public static Q931 create(Rider rider) {
        return Q931Factory.create(rider.read(), rider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Q931 create(int n, Rider rider) {
        switch (n) {
            case 4: {
                return new BearerCapability(rider);
            }
            case 8: {
                return new Cause(rider);
            }
            case 24: {
                return new ChannelIdentification(rider);
            }
            case 30: {
                return new ProgressIndicator(rider);
            }
            case 40: {
                return new Display(rider);
            }
            case 41: {
                return new Q931Date(rider);
            }
            case 44: {
                return new KeypadFacility(rider);
            }
            case 108: {
                return new CallingPartyNumber(rider);
            }
            case 109: {
                return new CallingPartySubAddress(rider);
            }
            case 112: {
                return new CalledPartyNumber(rider);
            }
            case 113: {
                return new CalledPartySubAddress(rider);
            }
            case 124: {
                return new LowLayerCompatibility(rider);
            }
            case 125: {
                return new HighLayerCompatibility(rider);
            }
            case 126: {
                return new UserUser(rider);
            }
            case 161: {
                return new SendingComplete(rider);
            }
        }
        System.err.println("Unimplemented IEI = 0x" + Integer.toHexString(n));
        rider.setLength();
        try {
            System.err.println(rider.toString());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        finally {
            rider.skip();
        }
        return new Q931();
    }
}

