/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.capi.samples;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.SourceDataLine;
import uk.co.mmscomputing.device.capi.CapiCallApplication;
import uk.co.mmscomputing.device.capi.CapiChannel;
import uk.co.mmscomputing.device.capi.CapiInputStream;
import uk.co.mmscomputing.device.capi.CapiMetadata;
import uk.co.mmscomputing.device.capi.StructOut;
import uk.co.mmscomputing.device.capi.ctrl.ConnectReq;
import uk.co.mmscomputing.device.capi.parameter.AdditionalInfo;
import uk.co.mmscomputing.device.capi.plc.DisconnectInd;
import uk.co.mmscomputing.device.capi.protocol.SpeechProtocol;
import uk.co.mmscomputing.device.capi.q931.CallingPartyNumber;
import uk.co.mmscomputing.device.capi.q931.KeypadFacility;
import uk.co.mmscomputing.device.capi.sound.PCMInputStream;
import uk.co.mmscomputing.sound.SoundMixerEnumerator;
import uk.co.mmscomputing.util.metadata.Metadata;
import uk.co.mmscomputing.util.metadata.MetadataListener;

public class KeypadCodeSender
implements MetadataListener,
Runnable {
    static AudioFormat pcmformat = new AudioFormat(8000.0f, 16, 1, true, false);
    static int bufsize = 512;
    CapiCallApplication appl;
    CapiMetadata md;
    Thread thread;
    String keypadcode;

    public KeypadCodeSender(String string, String string2) throws IOException {
        this.keypadcode = string2;
        this.md = new CapiMetadata();
        this.md.useMaxLogicalConnections(1);
        this.md.useController(1);
        this.md.useALaw();
        this.md.use64kBit();
        this.md.addListener(this);
        this.md.putString("capi.localno", string);
        this.appl = new CapiCallApplication(this.md);
        this.appl.start();
    }

    private CapiChannel connectKeyPad(String string) throws IOException {
        int n = this.md.getInt("capi.bandwidth");
        int n2 = this.md.getInt("capi.controller.id");
        String string2 = this.md.getString("capi.localno");
        System.out.println("msn = " + string2 + " dial keypad code = " + string);
        KeypadFacility.Out out = new KeypadFacility.Out(string);
        AdditionalInfo.Out out2 = new AdditionalInfo.Out(out);
        CallingPartyNumber.Out out3 = new CallingPartyNumber.Out(string2);
        ConnectReq connectReq = new ConnectReq(this.appl.getApplID(), n2, 1, StructOut.empty, out3, StructOut.empty, StructOut.empty, (StructOut)new SpeechProtocol(), StructOut.empty, StructOut.empty, StructOut.empty, (StructOut)out2);
        return this.appl.connect(connectReq, 20000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            System.err.println("Try connecting to " + this.keypadcode + ". Will wait for 20 sec.");
            CapiChannel capiChannel = this.connectKeyPad(this.keypadcode);
            System.err.println("Connected to " + this.keypadcode);
            try {
                int n;
                SourceDataLine sourceDataLine = SoundMixerEnumerator.getOutputLine(pcmformat, bufsize);
                CapiInputStream capiInputStream = capiChannel.getInputStream();
                PCMInputStream pCMInputStream = new PCMInputStream(capiInputStream, capiChannel.isALaw());
                int n2 = 0;
                byte[] byArray = new byte[bufsize];
                sourceDataLine.start();
                while (capiChannel.isOpen() && (n = ((InputStream)pCMInputStream).read(byArray)) != -1) {
                    sourceDataLine.write(byArray, 0, n);
                    n2 += n;
                }
                ((InputStream)pCMInputStream).close();
                sourceDataLine.drain();
                sourceDataLine.stop();
                sourceDataLine.close();
                System.err.println("wrote input " + n2 + " byte(s)");
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.err.println(exception.getMessage());
            }
            capiChannel.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
        finally {
            this.appl.close();
        }
    }

    public void update(Object object, Metadata metadata) {
        if (!(object instanceof DisconnectInd)) {
            if (object instanceof Exception) {
                System.err.println(object);
                ((Exception)object).printStackTrace();
            } else {
                System.err.println(object);
            }
        }
    }

    public void checkInput() throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        while ((string = bufferedReader.readLine()) != null) {
            if (!string.equals("quit")) continue;
            this.appl.close();
            break;
        }
        bufferedReader.close();
    }

    public static void main(String[] stringArray) {
        try {
            String string = "12345";
            if (stringArray.length > 0) {
                string = stringArray[0];
            }
            String string2 = "*#001#";
            if (stringArray.length > 1) {
                string2 = stringArray[1];
            }
            System.err.println("\nStart KeypadCodeSender : msn=" + string + " keypad code=" + string2);
            System.err.println("\n\tType 'quit' on command line to quit:)\n");
            KeypadCodeSender keypadCodeSender = new KeypadCodeSender(string, string2);
            new Thread(keypadCodeSender).start();
            keypadCodeSender.checkInput();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.err.println("\n\nInvalid arguments:\nUsage: java uk.co.mmscomputing.device.capi.samples.KeypadCodeSender localno keypadcode\n\n");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.err.println("End KeypadCodeSender.");
    }
}

