/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.capi.samples;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import uk.co.mmscomputing.concurrent.Semaphore;
import uk.co.mmscomputing.concurrent.TimeUnit;
import uk.co.mmscomputing.device.capi.CapiMetadata;
import uk.co.mmscomputing.device.capi.CapiServerApplication;
import uk.co.mmscomputing.device.capi.exception.CapiException;
import uk.co.mmscomputing.device.capi.facility.HandsetReq;
import uk.co.mmscomputing.device.capi.ncc.DataB3Conf;
import uk.co.mmscomputing.device.capi.ncc.DataB3Ind;
import uk.co.mmscomputing.device.capi.plc.DisconnectInd;
import uk.co.mmscomputing.util.metadata.Metadata;
import uk.co.mmscomputing.util.metadata.MetadataListener;

public class SimpleDTMFActuator
implements MetadataListener,
Runnable {
    CapiServerApplication appl;
    String dtmfcode;
    String cmd = "";

    public SimpleDTMFActuator(String string, String string2) throws IOException {
        this.dtmfcode = string;
        this.cmd = string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void run() {
        try {
            var1_1 = new CapiMetadata();
            var1_1.useMaxLogicalConnections(1);
            var1_1.useController(1);
            var1_1.useALaw();
            var1_1.use64kBit();
            var1_1.acceptAllCalls();
            var1_1.addListener(this);
            this.appl = new CapiServerApplication(var1_1);
            this.appl.start();
            while (true) lbl-1000:
            // 4 sources

            {
                var2_3 = this.appl.accept();
                try {
                    var2_3.getInputStream().close();
                    var3_4 = new HandsetReq(var2_3.getApplID(), var2_3.getLineID());
                    var2_3.put(var3_4);
                    System.err.println("START DTMF wait for signal = " + this.dtmfcode);
                    var2_3.startDTMF();
                    var4_6 = var2_3.getDTMFDigits(this.dtmfcode.length(), 20000);
                    System.err.println("DTMF '" + var4_6 + "' [" + this.dtmfcode + "]");
                    if (this.dtmfcode.equals(var4_6)) {
                        this.runCommand(this.cmd);
                        var2_3.sendDTMF("0099009900");
                        new Semaphore(0, true).tryAcquire(2000L, TimeUnit.MILLISECONDS);
                    } else {
                        System.err.println("Do not process command " + this.cmd + "\n\tReceived " + var4_6);
                        var2_3.sendDTMF("0000000000");
                        new Semaphore(0, true).tryAcquire(2000L, TimeUnit.MILLISECONDS);
                    }
                    var2_3.stopDTMF();
                }
                catch (InterruptedException var3_5) {
                    System.err.println(var3_5);
                }
                finally {
                    System.err.println("STOP DTMF");
                    var2_3.close();
                    continue;
                }
                break;
            }
        }
        catch (Exception var1_2) {
            System.err.println(var1_2.getMessage());
            return;
        }
        ** GOTO lbl-1000
    }

    public void update(Object object, Metadata metadata) {
        if (object instanceof DisconnectInd) {
            System.err.println("\nDisconnect\n\n");
        } else if (object instanceof CapiMetadata.Indication) {
            this.handleIndication((CapiMetadata.Indication)object);
        } else if (object instanceof CapiException) {
            System.err.println(object);
        } else if (object instanceof Exception) {
            ((Exception)object).printStackTrace();
        } else if (!(object instanceof DataB3Ind) && !(object instanceof DataB3Conf)) {
            System.err.println(object);
        }
    }

    public void handleIndication(CapiMetadata.Indication indication) {
        System.out.println("local  no = " + indication.localno);
        System.out.println("remote no = " + indication.remoteno);
        indication.setAccept(0);
    }

    public void runCommand(String string) {
        System.err.println("Start Cmd : " + string);
        try {
            String string2;
            Process process = Runtime.getRuntime().exec(string);
            final BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(process.getInputStream()));
            new Thread(){

                public void run() {
                    try {
                        String string;
                        while ((string = bufferedReader.readLine()) != null) {
                            System.err.println("stderr: " + string);
                        }
                    }
                    catch (IOException iOException) {
                        System.err.println(iOException);
                    }
                }
            }.start();
            while ((string2 = bufferedReader2.readLine()) != null) {
                System.err.println("stdout: " + string2);
            }
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
        System.err.println("Finished cmd : " + string);
    }

    public void checkInput() throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        while ((string = bufferedReader.readLine()) != null) {
            if (!string.equals("quit")) continue;
            this.appl.close();
            break;
        }
        bufferedReader.close();
    }

    public static void main(String[] stringArray) {
        String string = "1234";
        if (stringArray.length > 0) {
            string = stringArray[0];
        }
        String string2 = "java -version";
        if (stringArray.length > 1) {
            string2 = stringArray[1];
        }
        System.err.println("\nStart SimpleDTMFActuator\n\tdtmfcode : " + string + "\n\tcommand : " + string2);
        System.err.println("\n\tType 'quit' on command line to quit :)\n");
        try {
            SimpleDTMFActuator simpleDTMFActuator = new SimpleDTMFActuator(string, string2);
            Thread thread = new Thread(simpleDTMFActuator);
            thread.start();
            simpleDTMFActuator.checkInput();
            thread.interrupt();
            System.err.println("End SimpleDTMFActuator.");
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }
}

