/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.capi.samples;

import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import uk.co.mmscomputing.device.capi.CapiChannel;
import uk.co.mmscomputing.device.capi.CapiEnumerator;
import uk.co.mmscomputing.device.capi.CapiInputStream;
import uk.co.mmscomputing.device.capi.CapiMetadata;
import uk.co.mmscomputing.device.capi.CapiServerApplication;
import uk.co.mmscomputing.device.capi.StructOut;
import uk.co.mmscomputing.device.capi.protocol.BProtocol;
import uk.co.mmscomputing.util.metadata.Metadata;
import uk.co.mmscomputing.util.metadata.MetadataListener;

public class SimpleModemDataReceiver
implements MetadataListener,
Runnable {
    static CapiMetadata md = new CapiMetadata();
    private static final int DefaultB3DataBlockSize = 128;
    CapiServerApplication server;

    public SimpleModemDataReceiver() throws IOException {
        CapiEnumerator capiEnumerator = new CapiEnumerator();
    }

    private void receive(final CapiChannel capiChannel, final String string) {
        new Thread(){

            public void run() {
                try {
                    int n;
                    CapiInputStream capiInputStream = capiChannel.getInputStream();
                    OutputStream outputStream = new FileOutputStream(string);
                    int n2 = (((InputStream)capiInputStream).read() & 0xFF) << 24;
                    n2 |= (((InputStream)capiInputStream).read() & 0xFF) << 16;
                    n2 |= (((InputStream)capiInputStream).read() & 0xFF) << 8;
                    int n3 = (n2 |= ((InputStream)capiInputStream).read() & 0xFF) / 128;
                    int n4 = n2 % 128;
                    System.out.println("Expect " + n2 + " bytes 0x" + Integer.toHexString(n2));
                    int n5 = 0;
                    byte[] byArray = new byte[128];
                    for (int i = 0; i < n3 && (n = capiInputStream.read(byArray)) != -1; ++i) {
                        outputStream.write(byArray, 0, n);
                        System.out.println("Received " + (n5 += n) + " bytes of " + n2);
                    }
                    n = ((InputStream)capiInputStream).read(byArray, 0, n4);
                    outputStream.write(byArray, 0, n);
                    System.out.println("Received " + (n5 += n) + " bytes of " + n2);
                    System.err.println(n5 == n2 ? "Successful Transfer" : "Unsuccessful Transfer");
                    outputStream.close();
                    outputStream = capiChannel.getOutputStream();
                    outputStream.write(n5 & 0xFF);
                    outputStream.write((n5 >>= 8) & 0xFF);
                    outputStream.write((n5 >>= 8) & 0xFF);
                    outputStream.write((n5 >>= 8) & 0xFF);
                    outputStream.flush();
                    outputStream.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }.start();
    }

    public void update(Object object, Metadata metadata) {
        if (object instanceof CapiMetadata.Indication) {
            this.handleIndication((CapiMetadata.Indication)object);
        } else if (object instanceof Exception) {
            System.err.println(object);
            ((Exception)object).printStackTrace();
        } else {
            System.err.println(object);
        }
    }

    public void handleIndication(CapiMetadata.Indication indication) {
        indication.setAccept(0);
        indication.protocol = new BProtocol(8, 1, 7, StructOut.empty, StructOut.empty, StructOut.empty, StructOut.empty);
    }

    public void run() {
        md.useMaxLogicalConnections(CapiEnumerator.getNoOfBChannels());
        md.useALaw();
        md.use64kBit();
        md.acceptAllCalls();
        md.useController(1);
        md.addListener(this);
        try {
            CapiChannel capiChannel;
            this.server = new CapiServerApplication(md);
            this.server.start();
            while ((capiChannel = this.server.accept()) != null) {
                this.receive(capiChannel, "uk/co/mmscomputing/SMDRTest.txt");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void checkInput() throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        while ((string = bufferedReader.readLine()) != null) {
            if (!string.equals("quit")) continue;
            this.server.close();
            break;
        }
        bufferedReader.close();
    }

    public static void main(String[] stringArray) {
        System.err.println("SimpleModemDataReceiver");
        try {
            SimpleModemDataReceiver simpleModemDataReceiver = new SimpleModemDataReceiver();
            new Thread(simpleModemDataReceiver).start();
            simpleModemDataReceiver.checkInput();
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }
}

