/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.capi.samples;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.channels.ClosedChannelException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;
import uk.co.mmscomputing.concurrent.Semaphore;
import uk.co.mmscomputing.device.capi.CapiCallApplication;
import uk.co.mmscomputing.device.capi.CapiChannel;
import uk.co.mmscomputing.device.capi.CapiMetadata;
import uk.co.mmscomputing.device.capi.CapiPLC;
import uk.co.mmscomputing.device.capi.facility.SupServiceReq;
import uk.co.mmscomputing.device.capi.plc.DisconnectInd;
import uk.co.mmscomputing.device.capi.plc.DisconnectReq;
import uk.co.mmscomputing.sound.SoundMixerEnumerator;
import uk.co.mmscomputing.util.metadata.Metadata;
import uk.co.mmscomputing.util.metadata.MetadataListener;

public class TalkTo
implements MetadataListener,
Runnable {
    static AudioFormat pcmformat = new AudioFormat(8000.0f, 16, 1, true, false);
    static int bufsize = 512;
    CapiCallApplication appl;
    Thread thread;
    CapiChannel ncc;
    String phoneno;
    CapiPLC plc;
    Semaphore blocker = new Semaphore(0, true);

    public TalkTo(String string) throws IOException {
        this.phoneno = string;
        CapiMetadata capiMetadata = new CapiMetadata();
        capiMetadata.useMaxLogicalConnections(1);
        capiMetadata.useController(1);
        capiMetadata.useALaw();
        capiMetadata.use64kBit();
        capiMetadata.addListener(this);
        this.appl = new CapiCallApplication(capiMetadata);
        this.appl.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            System.err.println("Try connecting to " + this.phoneno + ". Will wait for 20 sec.");
            this.ncc = this.appl.connect(this.phoneno, 20000L);
            System.err.println("Connected to " + this.phoneno);
            this.plc = this.appl.getPLC(this.ncc.getLineID());
            this.plc.put(new SupServiceReq.ListenReq(this.plc.getApplID(), this.plc.getLineID()));
            do {
                System.err.println("Start Speaker Output/Mic Input. [0x" + Integer.toHexString(this.ncc.getLineID()) + "]");
                new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        SourceDataLine sourceDataLine = null;
                        try {
                            sourceDataLine = SoundMixerEnumerator.getOutputLine(pcmformat, bufsize);
                            TalkTo.this.ncc.writeInputTo(sourceDataLine);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        finally {
                            if (sourceDataLine != null) {
                                sourceDataLine.close();
                            }
                        }
                        System.err.println("Stop Speaker Output.");
                    }
                }.start();
                TargetDataLine targetDataLine = null;
                try {
                    targetDataLine = SoundMixerEnumerator.getInputLine(pcmformat, bufsize);
                    this.ncc.writeToOutput(targetDataLine);
                }
                catch (ClosedChannelException closedChannelException) {
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                finally {
                    if (targetDataLine != null) {
                        targetDataLine.close();
                    }
                }
                System.err.println("Stop Mic Input.");
                if (!this.plc.isOnHold()) continue;
                System.err.println("PLC on hold.");
                this.blocker.acquire();
                this.ncc = this.plc.retrieveChannel();
            } while (!this.plc.isDisconnected());
            System.err.println("Close Channel.");
            this.plc.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            this.appl.close();
        }
        System.err.println("Type 'quit' to end program.");
    }

    public void update(Object object, Metadata metadata) {
        if (object instanceof DisconnectInd) {
            this.blocker.release();
        } else if (!(object instanceof DisconnectReq)) {
            if (object instanceof Exception) {
                System.err.println(object);
                ((Exception)object).printStackTrace();
            } else {
                System.err.println(object.toString());
            }
        }
    }

    public void checkInput() throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        while ((string = bufferedReader.readLine()) != null) {
            if (string.equals("hold")) {
                System.out.println("input: " + string);
                this.plc.hold();
                continue;
            }
            if (string.equals("retrieve")) {
                System.out.println("input: " + string);
                this.plc.retrieve();
                this.blocker.release();
                continue;
            }
            if (!string.equals("quit")) continue;
            this.blocker.release();
            this.appl.close();
            break;
        }
        bufferedReader.close();
    }

    public static void main(String[] stringArray) {
        try {
            String string = "**20";
            if (stringArray.length > 0) {
                string = stringArray[0];
            }
            System.err.println("\nStart TalkTo : " + string);
            System.err.println("\n\tType 'quit' on command line to quit:)\n");
            TalkTo talkTo = new TalkTo(string);
            new Thread(talkTo).start();
            talkTo.checkInput();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.err.println("\n\nPlease supply a valid phone number as an argument.\n\n");
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
        System.err.println("End TalkTo.");
        System.exit(0);
    }
}

