/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.capi.samples;

import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import uk.co.mmscomputing.device.capi.CapiChannel;
import uk.co.mmscomputing.device.capi.CapiEnumerator;
import uk.co.mmscomputing.device.capi.CapiInputStream;
import uk.co.mmscomputing.device.capi.CapiMetadata;
import uk.co.mmscomputing.device.capi.CapiOutputStream;
import uk.co.mmscomputing.device.capi.CapiServerApplication;
import uk.co.mmscomputing.device.capi.StructOut;
import uk.co.mmscomputing.device.capi.protocol.BProtocol;
import uk.co.mmscomputing.util.metadata.Metadata;
import uk.co.mmscomputing.util.metadata.MetadataListener;

public class TerminalEchoServer
implements MetadataListener,
Runnable {
    private CapiServerApplication server;

    private void receive(final CapiChannel capiChannel, final String string) {
        new Thread(){

            public void run() {
                try {
                    int n;
                    CapiInputStream capiInputStream = capiChannel.getInputStream();
                    CapiOutputStream capiOutputStream = capiChannel.getOutputStream();
                    FileOutputStream fileOutputStream = new FileOutputStream(string);
                    int n2 = 0;
                    while ((n = ((InputStream)capiInputStream).read()) != -1 && n != 27) {
                        System.out.println("Received Byte [" + n2 + "]" + (char)n + " " + Integer.toHexString(n));
                        ((OutputStream)capiOutputStream).write(n);
                        ((OutputStream)capiOutputStream).flush();
                        ((OutputStream)fileOutputStream).write(n);
                        ++n2;
                    }
                    ((OutputStream)fileOutputStream).close();
                    capiChannel.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }.start();
    }

    public void update(Object object, Metadata metadata) {
        if (object instanceof CapiMetadata.Indication) {
            this.handleIndication((CapiMetadata.Indication)object);
        } else if (object instanceof Exception) {
            System.err.println(object);
            ((Exception)object).printStackTrace();
        } else {
            System.err.println(object);
        }
        System.out.println(object);
    }

    public void handleIndication(CapiMetadata.Indication indication) {
        indication.setAccept(0);
        StructOut structOut = new StructOut(12);
        structOut.writeWord(0);
        structOut.writeWord(8);
        structOut.writeWord(0);
        structOut.writeWord(0);
        structOut.writeWord(2);
        structOut.writeWord(3);
        indication.protocol = new BProtocol(7, 7, 7, structOut, StructOut.empty, StructOut.empty, StructOut.empty);
    }

    public void run() {
        CapiMetadata capiMetadata = new CapiMetadata();
        capiMetadata.useMaxLogicalConnections(CapiEnumerator.getNoOfBChannels());
        capiMetadata.useALaw();
        capiMetadata.use64kBit();
        capiMetadata.acceptAllCalls();
        capiMetadata.useController(1);
        capiMetadata.addListener(this);
        try {
            CapiChannel capiChannel;
            this.server = new CapiServerApplication(capiMetadata);
            this.server.start();
            while ((capiChannel = this.server.accept()) != null) {
                this.receive(capiChannel, "uk/co/mmscomputing/TESTest.txt");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void checkInput() throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        while ((string = bufferedReader.readLine()) != null) {
            if (!string.equals("quit")) continue;
            this.server.close();
            break;
        }
        bufferedReader.close();
    }

    public static void main(String[] stringArray) {
        System.err.println("TerminalEchoServer");
        try {
            TerminalEchoServer terminalEchoServer = new TerminalEchoServer();
            new Thread(terminalEchoServer).start();
            terminalEchoServer.checkInput();
            System.err.println("Stopped TerminalEchoServer");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

