/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.fax;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import uk.co.mmscomputing.device.fax.FaxCallHandler;
import uk.co.mmscomputing.device.fax.FaxConstants;

public class FaxCallSaver
extends Thread
implements FaxConstants,
FaxCallHandler {
    protected Properties properties;
    protected String filename = null;
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss-SSS-");
    private static int msgno = 0;

    public String getFile() {
        return this.filename;
    }

    public void init(Properties properties) {
        this.properties = properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String string, String string2, InputStream inputStream, OutputStream outputStream) {
        FileOutputStream fileOutputStream = null;
        try {
            this.filename = this.createFilePath(string, string2, ".sff");
            File file = new File(this.filename);
            fileOutputStream = new FileOutputStream(file);
            this.write(inputStream, fileOutputStream);
        }
        catch (Exception exception) {
            System.out.println("9\b" + this.getClass().getName() + ".run\n\tDisconnected call.\n\t" + exception);
            exception.printStackTrace();
        }
        finally {
            try {
                inputStream.close();
                outputStream.close();
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (Exception exception) {
                System.out.println(this.getClass().getName() + ".run:\n\t" + exception);
            }
        }
    }

    protected String createFilePath(String string, String string2, String string3) {
        File file;
        File file2 = new File(this.properties.getProperty("uk.co.mmscomputing.device.faxreceiver.dir"));
        String string4 = string2.replaceAll("\\*\\*", "");
        try {
            string3 = this.properties.getProperty("uk.co.mmscomputing.device.fax.filetype", string3);
        }
        catch (Exception exception) {
            System.out.println("3\b" + this.getClass().getName() + ".run\n\tCould not set file type extension.\n\t" + exception);
        }
        String string5 = sdf.format(new Date()) + msgno++ + "_" + string + "_" + string4 + "." + string3;
        try {
            file2.mkdirs();
            file = new File(file2.getAbsolutePath(), string5);
        }
        catch (Exception exception) {
            System.out.println("9\b" + this.getClass().getName() + ".createFilePath:\n\tCould not create directory:\n\t" + file2.getAbsolutePath());
            file = new File(string5);
        }
        return file.getAbsolutePath();
    }

    protected void write(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[256];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }
}

