/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.fax;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.Properties;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import uk.co.mmscomputing.device.fax.FaxCallHandler;
import uk.co.mmscomputing.device.fax.FaxCallHandlerFactory;
import uk.co.mmscomputing.device.fax.FaxCallMonitor;
import uk.co.mmscomputing.device.fax.FaxCallSaver;
import uk.co.mmscomputing.device.fax.FaxColumnModel;
import uk.co.mmscomputing.device.fax.FaxConstants;
import uk.co.mmscomputing.device.fax.FaxEntry;
import uk.co.mmscomputing.device.fax.FaxModel;
import uk.co.mmscomputing.device.fax.FaxReceiverListener;
import uk.co.mmscomputing.device.fax.FaxReceiverMetadata;
import uk.co.mmscomputing.device.fax.IndicationProgressMonitor;
import uk.co.mmscomputing.device.phone.PhoneBook;

public class FaxReceiverPanel
extends JPanel
implements FaxConstants,
FaxCallHandlerFactory,
FaxReceiverListener {
    protected Properties properties;
    protected FaxCallHandlerFactory handlerfactory;
    protected PhoneBook phonebook;
    private JTable table;
    private FaxModel model = new FaxModel();
    private FaxColumnModel columnmodel = new FaxColumnModel();
    private static boolean addedFaxImageListener = false;
    private static boolean addedPhoneBookListener = false;

    public FaxReceiverPanel(Properties properties, PhoneBook phoneBook) {
        this.properties = properties;
        this.phonebook = phoneBook;
        this.handlerfactory = this;
        this.setLayout(new BorderLayout());
        this.table = new JTable(this.model, this.columnmodel);
        this.table.createDefaultColumnsFromModel();
        this.table.getTableHeader().setReorderingAllowed(false);
        this.add((Component)new JScrollPane(this.table), "Center");
        properties.setProperty("uk.co.mmscomputing.device.faxreceiver.dir", properties.getProperty("uk.co.mmscomputing.device.faxreceiver.dir", faxDefaultPath));
        this.buildCallList(properties.getProperty("uk.co.mmscomputing.device.faxreceiver.dir"));
        this.table.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.isMetaDown()) {
                    int n = FaxReceiverPanel.this.table.rowAtPoint(new Point(mouseEvent.getX(), mouseEvent.getY()));
                    FaxReceiverPanel.this.table.setRowSelectionInterval(n, n);
                    if (mouseEvent.getClickCount() == 2) {
                        FaxReceiverPanel.this.deleteFaxes();
                    }
                } else if (mouseEvent.isShiftDown()) {
                    int n = FaxReceiverPanel.this.table.rowAtPoint(new Point(mouseEvent.getX(), mouseEvent.getY()));
                    FaxReceiverPanel.this.table.setRowSelectionInterval(n, n);
                    if (mouseEvent.getClickCount() == 2) {
                        FaxReceiverPanel.this.updatePhoneBook(FaxReceiverPanel.this.model.getRemote(n));
                    }
                } else if (mouseEvent.getClickCount() == 2) {
                    int n = FaxReceiverPanel.this.table.getSelectedRow();
                    if (n == -1) {
                        return;
                    }
                    FaxReceiverPanel.this.table.setRowSelectionInterval(n, n);
                    FaxReceiverPanel.this.showFax(FaxReceiverPanel.this.model.getTime(n), FaxReceiverPanel.this.model.getLocal(n), FaxReceiverPanel.this.model.getRemote(n), FaxReceiverPanel.this.model.getFile(n));
                }
            }
        });
    }

    private void addPropertyChangeListener(String string) {
        for (Container container = this.getParent(); container != null; container = container.getParent()) {
            Component component;
            JTabbedPane jTabbedPane;
            int n;
            if (!(container instanceof JTabbedPane) || (n = (jTabbedPane = (JTabbedPane)container).indexOfTab(string)) == -1 || !((component = jTabbedPane.getComponentAt(n)) instanceof PropertyChangeListener)) continue;
            PropertyChangeListener propertyChangeListener = (PropertyChangeListener)((Object)component);
            this.addPropertyChangeListener(propertyChangeListener);
            return;
        }
    }

    public void setHandlerFactory(FaxCallHandlerFactory faxCallHandlerFactory) {
        this.handlerfactory = faxCallHandlerFactory;
    }

    public FaxCallHandler getHandler(Properties properties) {
        FaxCallSaver faxCallSaver = new FaxCallSaver();
        faxCallSaver.init(properties);
        return faxCallSaver;
    }

    protected void showFax(String string, String string2, String string3, String string4) {
        if (!addedFaxImageListener) {
            addedFaxImageListener = true;
            this.addPropertyChangeListener("Fax Image");
        }
        this.firePropertyChange("open", null, string4);
    }

    protected void updatePhoneBook(String string) {
        if (!addedPhoneBookListener) {
            addedPhoneBookListener = true;
            this.addPropertyChangeListener("Phone Book");
        }
        this.firePropertyChange("update", null, string);
    }

    protected void deleteFaxes() {
        int[] nArray = this.table.getSelectedRows();
        for (int i = nArray.length - 1; i >= 0; --i) {
            ((FaxModel)this.table.getModel()).delEntry(nArray[i]);
        }
        this.table.revalidate();
    }

    private int getPickUpTime(String string) {
        try {
            String[] stringArray = this.properties.getProperty("uk.co.mmscomputing.device.fax.localnos", "").split(",");
            if (stringArray.length == 1 && stringArray[0].equals("")) {
                try {
                    return Integer.parseInt(this.properties.getProperty("uk.co.mmscomputing.device.fax.timetowait"));
                }
                catch (Exception exception) {
                    System.out.println("3\b" + this.getClass().getName() + ".update:\n\tCould not set pick up time.\n\t" + exception);
                    return 20;
                }
            }
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string.trim().equals(stringArray[i])) continue;
                try {
                    return Integer.parseInt(this.properties.getProperty("uk.co.mmscomputing.device.fax.timetowait"));
                }
                catch (Exception exception) {
                    System.out.println("3\b" + this.getClass().getName() + ".update:\n\tCould not set pick up time.\n\t" + exception);
                    return 20;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }

    public void update(FaxReceiverMetadata.Type type, FaxReceiverMetadata faxReceiverMetadata) {
        block12: {
            try {
                if (!type.equals(FaxReceiverMetadata.STATE)) break block12;
                if (faxReceiverMetadata.isState(1)) {
                    int n = this.getPickUpTime(faxReceiverMetadata.getLocalNo());
                    if (n == -1) break block12;
                    String string = faxReceiverMetadata.getRemoteNo();
                    IndicationProgressMonitor indicationProgressMonitor = new IndicationProgressMonitor(faxReceiverMetadata.getController(), string, this.phonebook.getName(string), n * 1000);
                    faxReceiverMetadata.setPickUpTime(n, indicationProgressMonitor);
                    try {
                        faxReceiverMetadata.setLocalNo(this.properties.getProperty("uk.co.mmscomputing.device.fax.localno"));
                    }
                    catch (Exception exception) {
                        System.out.println("3\b" + this.getClass().getName() + ".update:\n\tCould not set local number.\n\t" + exception);
                        faxReceiverMetadata.setLocalNo("012345");
                    }
                    try {
                        faxReceiverMetadata.setHeader(this.properties.getProperty("uk.co.mmscomputing.device.fax.header"));
                    }
                    catch (Exception exception) {
                        System.out.println("3\b" + this.getClass().getName() + ".update:\n\tCould not set fax header.\n\t" + exception);
                        faxReceiverMetadata.setHeader("My Fax Header");
                    }
                    break block12;
                }
                if (faxReceiverMetadata.isState(2)) {
                    FaxCallHandler faxCallHandler = this.handlerfactory.getHandler(this.properties);
                    faxReceiverMetadata.setHandler(faxCallHandler);
                } else if (faxReceiverMetadata.isState(0)) {
                    String string;
                    FaxCallHandler faxCallHandler = faxReceiverMetadata.getHandler();
                    if (faxCallHandler instanceof FaxCallMonitor && (string = ((FaxCallMonitor)faxCallHandler).getFile()) != null) {
                        this.model.addEntry(this.parseFileName(new File(string)));
                        this.table.revalidate();
                    }
                    if (faxCallHandler instanceof FaxCallSaver && (string = ((FaxCallMonitor)faxCallHandler).getFile()) != null) {
                        this.model.addEntry(this.parseFileName(new File(string)));
                        this.table.revalidate();
                    }
                }
            }
            catch (Exception exception) {
                System.out.println("9\b" + this.getClass().getName() + ".update:\n\t" + exception);
                exception.printStackTrace();
            }
        }
    }

    private FaxEntry parseFileName(File file) {
        String string = file.getName();
        String[] stringArray = (string = string.substring(0, string.indexOf(46))).split("_");
        String string2 = stringArray.length >= 1 ? stringArray[0] : "unknown";
        String string3 = stringArray.length >= 2 ? stringArray[1].replace('-', ':') : "unknown";
        String string4 = stringArray.length >= 3 ? stringArray[2] : "unknown";
        String string5 = stringArray.length >= 4 ? stringArray[3] : "withhold";
        String string6 = this.phonebook.getName(string5);
        return new FaxEntry(string2 + " " + string3, string4, string5, string6, file.getAbsolutePath());
    }

    private void buildCallList(String string) {
        String[] stringArray = this.list(string, new fnf());
        for (int i = 0; i < stringArray.length; ++i) {
            File file = new File(string, stringArray[i]);
            try {
                this.model.addEntry(this.parseFileName(file));
                continue;
            }
            catch (Exception exception) {
                System.out.println(this.getClass().getName() + ".parseFileName:\n\t" + exception);
                exception.printStackTrace();
            }
        }
    }

    public String[] list(String string, FilenameFilter filenameFilter) {
        Object[] objectArray = new File(string).list(filenameFilter);
        if (objectArray == null) {
            return new String[0];
        }
        Arrays.sort(objectArray);
        return objectArray;
    }

    class fnf
    implements FilenameFilter {
        fnf() {
        }

        public boolean accept(File file, String string) {
            File file2 = new File(file, string);
            return file2.isFile() && (string.endsWith(".sff") || string.endsWith(".tif") || string.endsWith(".tiff"));
        }
    }
}

