/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.fax;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import uk.co.mmscomputing.device.capi.CapiVoicePlugin;
import uk.co.mmscomputing.device.fax.FaxCallHandler;
import uk.co.mmscomputing.device.fax.FaxConstants;
import uk.co.mmscomputing.device.fax.FaxReceiverListener;
import uk.co.mmscomputing.device.fax.FaxReceiverMetadata;

public class MainApp
implements FaxConstants,
FaxReceiverListener {
    private File parent = new File(System.getProperty("user.home"), "mmsc" + File.separator + "fax" + File.separator + "rec");
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss_");

    public MainApp() {
        this.parent.mkdirs();
    }

    public void update(FaxReceiverMetadata.Type type, FaxReceiverMetadata faxReceiverMetadata) {
        try {
            if (type.equals(FaxReceiverMetadata.STATE)) {
                if (faxReceiverMetadata.isState(1)) {
                    faxReceiverMetadata.setPickUpTime(5);
                } else if (faxReceiverMetadata.isState(2)) {
                    faxReceiverMetadata.setHandler(new Handler());
                } else if (faxReceiverMetadata.isState(0)) {
                    Handler handler = (Handler)faxReceiverMetadata.getHandler();
                    System.out.println("New Fax: " + handler.file.getAbsolutePath());
                }
            }
        }
        catch (Exception exception) {
            System.out.println(this.getClass().getName() + ".update:\n\t" + exception);
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        try {
            MainApp mainApp = new MainApp();
            CapiVoicePlugin.getDefaultPlugin().addListener(mainApp);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private class Handler
    implements FaxCallHandler {
        File file;

        private Handler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(String string, String string2, InputStream inputStream, OutputStream outputStream) {
            OutputStream outputStream2 = null;
            try {
                int n;
                String string3 = string2.replaceAll("\\*\\*", "");
                String string4 = sdf.format(new Date()) + string + "_" + string3 + ".sff";
                this.file = new File(MainApp.this.parent, string4);
                outputStream2 = new FileOutputStream(this.file);
                byte[] byArray = new byte[2048];
                while ((n = inputStream.read(byArray)) != -1) {
                    outputStream2.write(byArray, 0, n);
                }
            }
            catch (Exception exception) {
                System.out.println(this.getClass().getName() + ".run:\n\t" + exception);
                exception.printStackTrace();
            }
            finally {
                try {
                    if (outputStream2 != null) {
                        outputStream2.flush();
                        outputStream2.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }
}

