/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.phone;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import uk.co.mmscomputing.concurrent.Semaphore;
import uk.co.mmscomputing.concurrent.TimeUnit;
import uk.co.mmscomputing.device.phone.PhoneCallHandler;
import uk.co.mmscomputing.device.phone.PhoneConstants;
import uk.co.mmscomputing.sound.WaveOutputFile;
import uk.co.mmscomputing.util.JarFile;

public class PhoneCallSaver
extends Thread
implements PhoneConstants,
PhoneCallHandler {
    protected Properties properties;
    protected boolean isrunning;
    private Player player = null;
    private String filename = null;
    private InputStream pin;
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss-SSS-");
    private static int msgno = 0;

    public String getFile() {
        return this.filename;
    }

    public void init(Properties properties) {
        this.properties = properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String string, String string2, InputStream inputStream, OutputStream outputStream) {
        this.pin = inputStream;
        WaveOutputFile waveOutputFile = null;
        try {
            this.isrunning = true;
            this.player = new Player(outputStream);
            this.player.start();
            this.filename = this.createFilePath(string, string2);
            waveOutputFile = new WaveOutputFile(new File(this.filename), pcmformat);
            this.write(inputStream, waveOutputFile);
            this.player.stopPlaying();
            this.stopRunning();
        }
        catch (Exception exception) {
            System.out.println("9\b" + this.getClass().getName() + ".run\n\tDisconnected call.\n\t" + exception);
            exception.printStackTrace();
        }
        finally {
            try {
                inputStream.close();
                outputStream.close();
                if (waveOutputFile != null) {
                    waveOutputFile.close();
                }
            }
            catch (Exception exception) {
                System.out.println("9\b" + this.getClass().getName() + ".run\n\tCould not close an i/o stream.\n\t" + exception);
            }
        }
    }

    public void stopRunning() {
        this.isrunning = false;
    }

    public void stopPlaying() {
        if (this.player != null) {
            this.player.stopPlaying();
        }
    }

    private String createFilePath(String string, String string2) {
        File file;
        File file2 = new File(this.properties.getProperty("uk.co.mmscomputing.device.phone.dir"));
        String string3 = string2.replaceAll("\\*\\*", "");
        String string4 = sdf.format(new Date()) + msgno++ + "_" + string + "_" + string3 + ".wav";
        try {
            file2.mkdirs();
            file = new File(file2.getAbsolutePath(), string4);
        }
        catch (Exception exception) {
            System.out.println("9\b" + this.getClass().getName() + ".createFilePath:\n\tCould not create directory:\n\t" + file2.getAbsolutePath());
            file = new File(string4);
        }
        return file.getAbsolutePath();
    }

    protected void write(InputStream inputStream, WaveOutputFile waveOutputFile) throws IOException {
        int n;
        byte[] byArray = new byte[512];
        while (this.isrunning && (n = inputStream.read(byArray)) != -1) {
            waveOutputFile.write(byArray, 0, n);
        }
    }

    private class Player
    extends Thread {
        private boolean isplaying;
        private Semaphore recordBlocker;
        private OutputStream pout;

        public Player(OutputStream outputStream) {
            this.pout = outputStream;
            this.isplaying = true;
            this.recordBlocker = new Semaphore(0, true);
        }

        public void stopPlaying() {
            if (this.isplaying) {
                this.isplaying = false;
                this.recordBlocker.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                int n;
                String string = PhoneCallSaver.this.properties.getProperty("uk.co.mmscomputing.device.phone.startmsg");
                String string2 = PhoneCallSaver.this.properties.getProperty("uk.co.mmscomputing.device.phone.endmsg");
                try {
                    n = Integer.parseInt(PhoneCallSaver.this.properties.getProperty("uk.co.mmscomputing.device.phone.timetorecord"));
                }
                catch (Exception exception) {
                    n = 60;
                }
                if (string != null && !string.equals("")) {
                    this.play(string, this.pout);
                }
                if (this.isplaying) {
                    for (int i = 0; i < n && PhoneCallSaver.this.isrunning; ++i) {
                        this.recordBlocker.tryAcquire(1000L, TimeUnit.MILLISECONDS);
                    }
                    if (this.isplaying && string2 != null && !string2.equals("")) {
                        this.play(string2, this.pout);
                    }
                }
            }
            catch (Exception exception) {
                System.out.println("9\b" + this.getClass().getName() + ".run\n\t" + exception);
            }
            finally {
                if (this.isplaying) {
                    this.isplaying = false;
                    PhoneCallSaver.this.stopRunning();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void play(String string, OutputStream outputStream) {
            AudioInputStream audioInputStream = null;
            try {
                int n;
                audioInputStream = AudioSystem.getAudioInputStream(new JarFile(string));
                audioInputStream = AudioSystem.getAudioInputStream(PhoneConstants.pcmformat, audioInputStream);
                byte[] byArray = new byte[512];
                while (PhoneCallSaver.this.isrunning && this.isplaying && (n = audioInputStream.read(byArray)) != -1) {
                    outputStream.write(byArray, 0, n);
                }
            }
            catch (IOException iOException) {
                System.out.println("3\b" + this.getClass().getName() + ".play\n\t" + iOException);
            }
            catch (Exception exception) {
                System.out.println("9\b" + this.getClass().getName() + ".play\n\t" + exception);
                exception.printStackTrace();
            }
            finally {
                try {
                    if (audioInputStream != null) {
                        audioInputStream.close();
                    }
                }
                catch (IOException iOException) {
                    System.out.println("3\b" + this.getClass().getName() + ".play\n\t" + iOException);
                }
            }
        }
    }
}

