/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.printmonitor;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public abstract class PMOutputStream
extends FilterOutputStream {
    private String cmd = "";
    private int count = 0;
    protected int pagewidth = 0;
    protected int pageheight = 0;
    protected int graphicsxres = 0;
    protected int graphicsyres = 0;
    protected int numofdatabytes = 0;

    public PMOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    protected abstract void startDoc() throws IOException;

    protected abstract void startPage() throws IOException;

    protected void sendBlockData() throws IOException {
        this.count = this.numofdatabytes;
    }

    protected abstract void writeDataByte(int var1) throws IOException;

    protected void endBlockData() throws IOException {
        int n = this.pagewidth >> 3;
        for (int i = this.numofdatabytes; i < n; ++i) {
            this.writeDataByte(0);
        }
    }

    protected abstract void endPage() throws IOException;

    protected abstract void endJob() throws IOException;

    private int getValue(String string) {
        try {
            String[] stringArray = string.split("=");
            return Integer.parseInt(stringArray[1]);
        }
        catch (Exception exception) {
            System.err.println(this.getClass().getName() + ".getValue:\n\t" + exception);
            return -1;
        }
    }

    private void processCmd(String string) throws IOException {
        if (string.startsWith("StartDoc")) {
            this.startDoc();
        } else if (string.startsWith("PhysPaperWidth")) {
            this.pagewidth = this.getValue(string);
        } else if (string.startsWith("PhysPaperLength")) {
            this.pageheight = this.getValue(string);
        } else if (string.startsWith("GraphicsXRes")) {
            this.graphicsxres = this.getValue(string);
        } else if (string.startsWith("GraphicsYRes")) {
            this.graphicsyres = this.getValue(string);
        } else if (string.startsWith("StartPage")) {
            this.startPage();
        } else if (string.startsWith("NumOfDataBytes")) {
            this.numofdatabytes = this.getValue(string);
            if (this.numofdatabytes << 3 > this.pagewidth) {
                System.err.println("Number of data bytes [" + this.numofdatabytes + "*8] is greater than pagewidth [" + this.pagewidth + "]");
            }
        } else if (string.startsWith("SendBlockData")) {
            this.sendBlockData();
        } else if (string.startsWith("EndBlockData")) {
            this.endBlockData();
        } else if (string.startsWith("EndPage")) {
            this.endPage();
        } else if (string.startsWith("EndJob")) {
            this.endJob();
        }
    }

    protected void addCmdChar(int n) throws IOException {
        if ((n &= 0xFF) == 59) {
            this.processCmd(this.cmd);
            this.cmd = "";
        } else {
            this.cmd = this.cmd + (char)n;
        }
    }

    public void write(int n) throws IOException {
        if (this.count > 0) {
            if (this.count <= this.pagewidth >> 3) {
                this.writeDataByte(n);
            }
            --this.count;
        } else {
            this.addCmdChar(n);
        }
    }
}

