/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.printmonitor;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import uk.co.mmscomputing.device.printmonitor.PMConfigurationPanel;
import uk.co.mmscomputing.device.printmonitor.Port;
import uk.co.mmscomputing.device.printmonitor.PortList;
import uk.co.mmscomputing.util.log.LogStream;

public class jprintmonitor {
    static String cn = "uk.co.mmscomputing.device.printmonitor.jprintmonitor";
    static PortList portlist = new PortList();
    private static String propertiesdir;

    private static int getPortInfoSize(int n) {
        try {
            System.out.println("getPortInfoSize level " + n);
            return portlist.getPortInfoSize(n);
        }
        catch (Throwable throwable) {
            System.err.println(cn + ".getPortInfoSize:\n\t" + throwable);
            return -1;
        }
    }

    private static int enumPorts(String string, int n, int n2, byte[] byArray) {
        try {
            System.out.println("enumPorts level " + n + " ptr = 0x" + Integer.toHexString(n2) + " buffer.length " + byArray.length);
            portlist.writePortInfo(n, n2, byArray);
            return portlist.size();
        }
        catch (Throwable throwable) {
            System.err.println(cn + ".enumPorts:\n\t" + throwable);
            return 0;
        }
    }

    private static boolean addPort(String string, int n, String string2) {
        try {
            Port port = new Port("make_my_name_unique", string2, "MMSC Print Port");
            if (port != null) {
                new PMConfigurationPanel(port, true).display();
                boolean bl = portlist.add(port);
                jprintmonitor.savePorts();
                return bl;
            }
            System.out.println("Cannot add Port. New port could not be allocated.");
        }
        catch (Throwable throwable) {
            System.err.println(cn + ".addPort:\n\t" + throwable);
        }
        return false;
    }

    private static boolean configurePort(String string, int n, String string2) {
        try {
            Port port = portlist.find(string2);
            if (port != null) {
                new PMConfigurationPanel(port, false).display();
                jprintmonitor.savePorts();
                return true;
            }
            System.out.println("Cannot configure Port " + string2 + ". Port could not be found.");
        }
        catch (Throwable throwable) {
            System.err.println(cn + ".configurePort:\n\t" + throwable);
        }
        return false;
    }

    private static boolean deletePort(String string, int n, String string2) {
        try {
            Port port = portlist.find(string2);
            if (port != null) {
                boolean bl = portlist.remove(port);
                jprintmonitor.savePorts();
                return bl;
            }
            System.out.println(cn + ".deletePort:\n\tCannot delete Port " + string2 + ". Port could not be found.");
        }
        catch (Throwable throwable) {
            System.err.println(cn + ".deletePort:\n\t" + throwable);
        }
        return false;
    }

    private static Port openPort(String string) {
        try {
            Port port = portlist.find(string);
            if (port != null && port.open()) {
                return port;
            }
        }
        catch (Throwable throwable) {
            System.err.println(cn + ".openPort:\n\t" + throwable);
        }
        return null;
    }

    private static File getPropertiesFile(String string) {
        String string2 = "uk.co.mmscomputing.device.printmonitor.properties.txt";
        try {
            return new File(string, string2);
        }
        catch (Throwable throwable) {
            System.err.println(cn + ".getPropertiesFile:\n\tCould not create directory:\n\t" + string + "\n\t" + throwable);
            return new File(string2);
        }
    }

    private static void loadPorts() {
        try {
            File file = jprintmonitor.getPropertiesFile(propertiesdir);
            if (file.exists()) {
                Properties properties = new Properties();
                properties.load(new FileInputStream(file));
                portlist.load(properties);
            }
        }
        catch (Throwable throwable) {
            System.err.println(cn + ".loadPorts:\n\t" + throwable);
        }
    }

    static void savePorts() {
        try {
            Properties properties = new Properties();
            portlist.save(properties);
            File file = jprintmonitor.getPropertiesFile(propertiesdir);
            properties.store(new FileOutputStream(file), file.getAbsolutePath());
        }
        catch (Throwable throwable) {
            System.err.println(cn + ".savePorts:\n\t" + throwable);
        }
    }

    static {
        try {
            propertiesdir = new File(System.getProperty("user.dir"), "uk.co.mmscomputing").getAbsolutePath();
            new File(propertiesdir).mkdirs();
            LogStream.redirectSystemOutToFile(new File(propertiesdir, "log.txt").getAbsolutePath());
            LogStream.redirectSystemErrToFile(new File(propertiesdir, "err.txt").getAbsolutePath());
            jprintmonitor.loadPorts();
        }
        catch (Throwable throwable) {
            System.err.println(cn + ".<static>:\n\t" + throwable);
        }
    }
}

