/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.sane.applet;

import java.applet.Applet;
import java.awt.Button;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import uk.co.mmscomputing.device.scanner.Scanner;
import uk.co.mmscomputing.device.scanner.ScannerDevice;
import uk.co.mmscomputing.device.scanner.ScannerIOException;
import uk.co.mmscomputing.device.scanner.ScannerIOMetadata;
import uk.co.mmscomputing.device.scanner.ScannerListener;

public class SaneAppletExample
extends Applet
implements ActionListener,
ScannerListener {
    String filename;
    Scanner scanner;
    Button acquireButton;
    Button selectButton;
    Button cancelButton;

    public SaneAppletExample() {
    }

    public SaneAppletExample(String string, String[] stringArray) {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame jFrame = new JFrame(string);
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                SaneAppletExample.this.stop();
                System.exit(0);
            }
        });
        this.init();
        jFrame.getContentPane().add(this);
        jFrame.pack();
        jFrame.setLocationRelativeTo(null);
        jFrame.setVisible(true);
        this.start();
    }

    public void init() {
        this.setLayout(new GridLayout(1, 3));
        this.selectButton = new Button("select");
        this.add(this.selectButton);
        this.selectButton.addActionListener(this);
        this.acquireButton = new Button("acquire");
        this.add(this.acquireButton);
        this.acquireButton.addActionListener(this);
        this.cancelButton = new Button("cancel next scan");
        this.add(this.cancelButton);
        this.cancelButton.addActionListener(this);
        this.filename = System.getProperty("user.home") + "/test.jpg";
        this.scanner = Scanner.getDevice();
        this.scanner.addListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            if (actionEvent.getSource() == this.acquireButton) {
                this.scanner.acquire();
            } else if (actionEvent.getSource() == this.selectButton) {
                this.scanner.select();
            } else if (actionEvent.getSource() == this.cancelButton) {
                this.scanner.setCancel(true);
            }
        }
        catch (ScannerIOException scannerIOException) {
            scannerIOException.printStackTrace();
        }
    }

    public void update(ScannerIOMetadata.Type type, ScannerIOMetadata scannerIOMetadata) {
        if (type.equals(ScannerIOMetadata.ACQUIRED)) {
            BufferedImage bufferedImage = scannerIOMetadata.getImage();
            System.out.println("Have an image now!");
            try {
                File file = new File(this.filename);
                System.out.println("Image Path: " + file.getAbsolutePath());
                ImageIO.write((RenderedImage)bufferedImage, "jpg", file);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if (type.equals(ScannerIOMetadata.NEGOTIATE)) {
            ScannerDevice scannerDevice = scannerIOMetadata.getDevice();
        } else if (type.equals(ScannerIOMetadata.STATECHANGE)) {
            System.err.println(scannerIOMetadata.getStateStr());
        } else if (type.equals(ScannerIOMetadata.EXCEPTION)) {
            scannerIOMetadata.getException().printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        try {
            SaneAppletExample saneAppletExample = new SaneAppletExample("Sane Applet Example [2007-11-19]", stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

