/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.sane.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.EventHandler;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTabbedPane;
import javax.swing.border.TitledBorder;
import uk.co.mmscomputing.concurrent.Semaphore;
import uk.co.mmscomputing.device.sane.OptionDescriptor;
import uk.co.mmscomputing.device.sane.SaneDevice;
import uk.co.mmscomputing.device.sane.SaneIOException;
import uk.co.mmscomputing.device.sane.gui.SanePreviewPanel;
import uk.co.mmscomputing.device.sane.gui.SaneSpecialPanel;
import uk.co.mmscomputing.device.sane.jsane;
import uk.co.mmscomputing.device.sane.option.Descriptor;
import uk.co.mmscomputing.util.JarImageIcon;

public class SaneAcquirePanel
extends JPanel
implements WindowListener {
    private static String previewtabstr = jsane.getResource("gui.SaneAcquirePanel.previewtabstr");
    private static String previewbutstr = jsane.getResource("gui.SaneAcquirePanel.previewbutstr");
    private static String scanstr = jsane.getResource("gui.SaneAcquirePanel.scanstr");
    private static String cancelstr = jsane.getResource("gui.SaneAcquirePanel.cancelstr");
    private static String progressbartitlestr = jsane.getResource("gui.SaneAcquirePanel.progressbartitlestr");
    private static String acquireframetitlestr = jsane.getResource("gui.SaneAcquirePanel.acquireframetitlestr");
    private JFrame dialog = null;
    private SaneDevice scanner;
    private SanePreviewPanel preview;
    private SaneSpecialPanel special;
    private JTabbedPane tp;
    private HashMap options;
    private Semaphore semaphore;

    public SaneAcquirePanel(SaneDevice saneDevice, Semaphore semaphore) throws SaneIOException {
        this.scanner = saneDevice;
        this.semaphore = semaphore;
        this.options = new HashMap();
        this.setLayout(new BorderLayout());
        this.tp = new JTabbedPane();
        this.buildTab();
        this.add((Component)this.tp, "Center");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JProgressBar jProgressBar = new JProgressBar();
        jProgressBar.setBorder(new TitledBorder(progressbartitlestr));
        jProgressBar.setStringPainted(true);
        jProgressBar.setMinimum(0);
        jProgressBar.setString(saneDevice.getName());
        jPanel.add((Component)jProgressBar, "Center");
        saneDevice.setProgressBar(jProgressBar);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 3));
        JButton jButton = new JButton(previewbutstr, new JarImageIcon(this.getClass(), "16x16/scanner.png"));
        jButton.addActionListener(EventHandler.create(ActionListener.class, this, "preview"));
        jPanel2.add(jButton);
        jButton = new JButton(scanstr);
        jButton.addActionListener(EventHandler.create(ActionListener.class, this, "scan"));
        jPanel2.add(jButton);
        jButton = new JButton(cancelstr);
        jButton.addActionListener(EventHandler.create(ActionListener.class, this, "cancelScan"));
        jPanel2.add(jButton);
        jPanel.add((Component)jPanel2, "South");
        this.add((Component)jPanel, "South");
    }

    private void close() {
        this.semaphore.release();
    }

    public void scan() {
        this.dialog.dispose();
    }

    public void cancelScan() {
        this.scanner.setCancel(true);
        this.dialog.dispose();
    }

    public void preview() {
        new Thread(this.preview).start();
    }

    private int build(JTabbedPane jTabbedPane, OptionDescriptor[] optionDescriptorArray, int n, boolean bl) {
        while (n < optionDescriptorArray.length) {
            Descriptor descriptor = (Descriptor)optionDescriptorArray[n];
            if (descriptor != null) {
                JComponent jComponent;
                if (descriptor.getType() == 5) {
                    if (bl) {
                        return n - 1;
                    }
                    jComponent = new JTabbedPane();
                    n = this.build((JTabbedPane)jComponent, optionDescriptorArray, n + 1, true);
                    if (((JTabbedPane)jComponent).getTabCount() > 0) {
                        jTabbedPane.addTab(descriptor.getTitle(), jComponent);
                    }
                } else {
                    try {
                        jComponent = descriptor.getGUI();
                        this.options.put(descriptor.getName(), descriptor);
                        jTabbedPane.addTab(descriptor.getTitle(), jComponent);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
            ++n;
        }
        return n;
    }

    public void buildTab() {
        this.tp.removeAll();
        try {
            this.build(this.tp, this.scanner.getOptionDescriptors(), 1, false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.special = new SaneSpecialPanel(this.scanner, this.options);
        this.tp.insertTab("jsane-Special", null, this.special, null, 0);
        this.preview = new SanePreviewPanel(this.scanner, this.options);
        this.tp.insertTab(previewtabstr, null, this.preview, null, 0);
        this.tp.setSelectedIndex(0);
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.scanner.setCancel(true);
    }

    public void windowClosed(WindowEvent windowEvent) {
        this.close();
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void display() {
        this.dialog = new JFrame(acquireframetitlestr);
        this.dialog.setDefaultCloseOperation(2);
        this.dialog.getContentPane().add(this);
        this.dialog.addWindowListener(this);
        this.dialog.setSize(400, 500);
        this.dialog.setLocationRelativeTo(null);
        this.dialog.setVisible(true);
    }
}

