/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.sane.gui;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.event.MouseInputAdapter;
import uk.co.mmscomputing.device.sane.SaneIOException;
import uk.co.mmscomputing.device.sane.gui.SanePreviewPanel;

public class SanePreviewImage
extends JComponent {
    protected BufferedImage image = new BufferedImage(1, 1, 1);
    protected Rectangle roi = new Rectangle(-1, -1, 0, 0);
    protected SanePreviewPanel spp = null;

    public SanePreviewImage(SanePreviewPanel sanePreviewPanel) {
        MIA mIA = new MIA();
        this.addMouseListener(mIA);
        this.addMouseMotionListener(mIA);
        this.setCursor(new Cursor(1));
        this.spp = sanePreviewPanel;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public void setImage(BufferedImage bufferedImage) {
        this.image = bufferedImage != null ? bufferedImage : new BufferedImage(1, 1, 1);
        this.roi.setBounds(-1, -1, 0, 0);
        this.setSize(this.image.getWidth(), this.image.getHeight());
        this.validate();
    }

    public void paint(Graphics graphics) {
        try {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.drawImage((Image)this.image, 0, 0, null);
            if (this.roi.width > 0 && this.roi.height > 0) {
                graphics2D.drawRect(this.roi.x, this.roi.y, this.roi.width, this.roi.height);
            }
        }
        catch (Error error) {
            this.setImage(null);
            System.gc();
            System.err.println(this.getClass().getName() + ".paint:\n\t" + error);
            error.printStackTrace();
            System.out.println("9\b" + this.getClass().getName() + ".paint:\n\t" + error);
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.image.getWidth(), this.image.getHeight());
    }

    class MIA
    extends MouseInputAdapter {
        MIA() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            SanePreviewImage.this.roi.setBounds(-1, -1, 0, 0);
            SanePreviewImage.this.repaint();
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            SanePreviewImage.this.roi.setBounds(point.x, point.y, 0, 0);
            SanePreviewImage.this.spp.setTopLeft(point);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (SanePreviewImage.this.roi.width > 0 && SanePreviewImage.this.roi.height > 0) {
                try {
                    SanePreviewImage.this.spp.setROI(SanePreviewImage.this.roi);
                }
                catch (SaneIOException saneIOException) {
                    saneIOException.printStackTrace();
                }
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            SanePreviewImage.this.spp.setXY(mouseEvent.getPoint());
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            SanePreviewImage.this.roi.setBounds(SanePreviewImage.this.roi.x, SanePreviewImage.this.roi.y, point.x - SanePreviewImage.this.roi.x + 1, point.y - SanePreviewImage.this.roi.y + 1);
            SanePreviewImage.this.spp.setBottomRight(point);
            SanePreviewImage.this.repaint();
        }
    }
}

